/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.internal.restclient.model.ImageStream;
import com.openshift.jenkins.plugins.pipeline.Auth;
import com.openshift.jenkins.plugins.pipeline.OpenShiftCreator;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPlugin;
import com.openshift.restclient.IClient;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.IResource;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public interface IOpenShiftImageTagger
extends IOpenShiftPlugin {
    public static final String DISPLAY_NAME = "Tag OpenShift Image";

    @Override
    default public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getAlias();

    public String getSrcTag();

    public String getDestTag();

    public String getSrcStream();

    public String getDestStream();

    public String getDestinationNamespace();

    public String getDestinationAuthToken();

    default public String getAlias(Map<String, String> overrides) {
        return this.getOverride(this.getAlias(), overrides);
    }

    default public String getSrcTag(Map<String, String> overrides) {
        return this.getOverride(this.getSrcTag(), overrides);
    }

    default public String getDestTag(Map<String, String> overrides) {
        return this.getOverride(this.getDestTag(), overrides);
    }

    default public String getSrcStream(Map<String, String> overrides) {
        return this.getOverride(this.getSrcStream(), overrides);
    }

    default public String getDestStream(Map<String, String> overrides) {
        return this.getOverride(this.getDestStream(), overrides);
    }

    default public String getDestinationNamespace(Map<String, String> overrides) {
        String destNS = this.getOverride(this.getDestinationNamespace(), overrides);
        return destNS.isEmpty() ? this.getNamespace(overrides) : destNS;
    }

    default public String getDestinationAuthToken(Map<String, String> overrides) {
        return this.getOverride(this.getDestinationAuthToken(), overrides);
    }

    default public String deriveImageID(String srcTag, IImageStream srcIS) {
        String srcImageID = srcIS.getImageId(srcTag);
        if (srcImageID != null && srcImageID.length() > 0) {
            srcImageID = srcIS.getName() + "@" + (srcImageID.startsWith("sha256:") ? srcImageID.substring(7) : srcImageID);
            return srcImageID;
        }
        ModelNode imageStream = ((ImageStream)srcIS).getNode();
        ModelNode status = imageStream.get("status");
        ModelNode tags = status.get("tags");
        if (tags.getType() != ModelType.LIST) {
            return null;
        }
        List tagWrappers = tags.asList();
        for (ModelNode tagWrapper : tagWrappers) {
            ModelNode tag = tagWrapper.get("tag");
            ModelNode items = tagWrapper.get("items");
            for (ModelNode itemWrapper : items.asList()) {
                ModelNode image = itemWrapper.get("image");
                if (image == null || !image.asString().equals(srcTag) && !image.asString().substring(7).equals(srcTag)) continue;
                return srcIS.getName() + "@" + (srcTag.startsWith("sha256:") ? srcTag.substring(7) : srcTag);
            }
        }
        return null;
    }

    default public String deriveImageTag(String imageID, IImageStream srcIS) {
        ModelNode imageStream = ((ImageStream)srcIS).getNode();
        ModelNode status = imageStream.get("status");
        ModelNode tags = status.get("tags");
        if (tags.getType() != ModelType.LIST) {
            return null;
        }
        List tagWrappers = tags.asList();
        for (ModelNode tagWrapper : tagWrappers) {
            ModelNode tag = tagWrapper.get("tag");
            ModelNode items = tagWrapper.get("items");
            for (ModelNode itemWrapper : items.asList()) {
                ModelNode image = itemWrapper.get("image");
                if (image == null || !image.asString().equals(imageID) && !image.asString().substring(7).equals(imageID)) continue;
                return tag.asString();
            }
        }
        return null;
    }

    @Override
    default public boolean coreLogic(Launcher launcher, TaskListener listener, Map<String, String> overrides) {
        String srcStream = this.getSrcStream(overrides);
        String srcTag = this.getSrcTag(overrides);
        String srcNS = this.getNamespace(overrides);
        String destStreams = this.getDestStream(overrides);
        String destTags = this.getDestTag(overrides);
        String destNS = this.getDestinationNamespace(overrides);
        listener.getLogger().println(String.format("\n\nStarting \"Tag OpenShift Image\" with the source [image stream:tag] \"%s:%s\" from the project \"%s\" and destination stream(s) \"%s\" with tag(s) \"%s\" from the project \"%s\".", srcStream, srcTag, srcNS, destStreams, destTags, destNS));
        boolean chatty = Boolean.parseBoolean(this.getVerbose(overrides));
        boolean useTag = Boolean.parseBoolean(this.getAlias(overrides));
        IClient srcClient = this.getClient(listener, DISPLAY_NAME, overrides);
        if (srcClient != null) {
            IClient destClient;
            String destToken;
            IImageStream srcIS = (IImageStream)srcClient.get("ImageStream", srcStream, srcNS);
            if (srcIS == null) {
                listener.getLogger().println(String.format("\n\nExiting \"Tag OpenShift Image\" unsuccessfully; could not retrieve the image stream \"%s\" from the project \"%s\".", srcStream, srcNS));
                return false;
            }
            if (chatty) {
                listener.getLogger().println("\n tag before verification: " + srcTag + " and alias " + useTag);
            }
            String srcImageID = null;
            String tagType = "ImageStreamTag";
            if (!useTag) {
                tagType = "ImageStreamImage";
                srcImageID = this.deriveImageID(srcTag, srcIS);
            } else {
                String tag2;
                Collection tags = srcIS.getTagNames();
                for (String tag2 : tags) {
                    if (!srcTag.equals(tag2)) continue;
                    srcImageID = srcStream + ":" + tag2;
                    break;
                }
                if (srcImageID == null && (tag2 = this.deriveImageTag(srcTag, srcIS)) != null) {
                    srcImageID = srcStream + ":" + tag2;
                }
            }
            if (srcImageID == null) {
                listener.getLogger().println(String.format("\n\nExiting \"Tag OpenShift Image\" unsuccessfully; could not find either an image tag or ID \"%s\" associated with the image stream \"%s\".", srcTag, srcStream));
                return false;
            }
            if (chatty) {
                listener.getLogger().println("\n srcImageID after translation " + srcImageID + " and tag type " + tagType);
            }
            if ((destToken = this.getDestinationAuthToken(overrides)) != null && !destToken.isEmpty()) {
                this.setAuth(Auth.createInstance((TaskListener)(chatty ? listener : null), this.getApiURL(overrides), overrides));
                destClient = this.getClient(listener, DISPLAY_NAME, overrides, destToken);
            } else {
                destClient = srcClient;
            }
            List<String> newDestinationStreams = Arrays.asList(destStreams.split(","));
            List<String> newDestTags = Arrays.asList(destTags.split(","));
            if (newDestinationStreams.size() != 1 && newDestTags.size() != 1 && newDestinationStreams.size() != newDestTags.size()) {
                String error = String.format("Destination streams (%s) cardinality [%d] is incompatible with destination tag (%s) cardinality [%d]", newDestinationStreams, newDestinationStreams.size(), newDestTags, newDestTags.size());
                throw new IllegalArgumentException(error);
            }
            Iterator<String> iDestStreams = newDestinationStreams.iterator();
            Iterator<String> iDestTags = newDestTags.iterator();
            String destStream = null;
            String destTag = null;
            block5: while (iDestStreams.hasNext() || iDestTags.hasNext()) {
                if (iDestStreams.hasNext()) {
                    destStream = iDestStreams.next().trim();
                }
                if (iDestTags.hasNext()) {
                    destTag = iDestTags.next().trim();
                }
                IImageStream destIS = null;
                for (int retries = 10; retries > 0; --retries) {
                    try {
                        destIS = (IImageStream)destClient.get("ImageStream", destStream, destNS);
                    }
                    catch (OpenShiftException e) {
                        String createJson = "{\"kind\": \"ImageStream\",\"apiVersion\": \"v1\",\"metadata\": {\"name\": \"" + destStream + "\",\"creationTimestamp\": null},\"spec\": {},\"status\": {\"dockerImageRepository\": \"\"}}";
                        HashMap<String, String> newOverrides = new HashMap<String, String>(overrides);
                        newOverrides.remove("namespace");
                        String token = destToken;
                        if (token == null || token.isEmpty()) {
                            token = this.getAuthToken();
                        }
                        OpenShiftCreator isCreator = new OpenShiftCreator(this.getApiURL(newOverrides), destNS, token, "" + chatty, createJson);
                        isCreator.setAuth(Auth.createInstance((TaskListener)(chatty ? listener : null), this.getApiURL(newOverrides), overrides));
                        boolean newISCreated = isCreator.coreLogic(launcher, listener, newOverrides);
                        if (!newISCreated) {
                            listener.getLogger().println(String.format("\n\nExiting \"Tag OpenShift Image\" unsuccessfully; could not create the image stream \"%s\" in the project \"%s\".", destStream, destNS));
                            return false;
                        }
                        destIS = (IImageStream)srcClient.get("ImageStream", destStream, destNS);
                    }
                    if (destIS == null) {
                        listener.getLogger().println(String.format("\n\nExiting \"Tag OpenShift Image\" unsuccessfully; could not retrieve the image stream \"%s\" from the project \"%s\".", destStream, destNS));
                        return false;
                    }
                    destIS.addTag(destTag, tagType, srcImageID, srcNS);
                    if (chatty) {
                        listener.getLogger().println("\n updated image stream json " + ((ImageStream)destIS).getNode().toJSONString(false) + " with tag: " + destTag);
                    }
                    try {
                        destClient.update((IResource)destIS);
                        continue block5;
                    }
                    catch (OpenShiftException ose) {
                        if (ose.getStatus().getCode() == 403 && retries > 1) continue;
                        throw ose;
                    }
                }
            }
            listener.getLogger().println(String.format("\n\nExiting \"%s\" successfully.", DISPLAY_NAME));
            return true;
        }
        return false;
    }
}

