/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.jenkins.plugins.pipeline.Argument;
import com.openshift.jenkins.plugins.pipeline.Auth;
import com.openshift.jenkins.plugins.pipeline.model.GlobalConfig;
import com.openshift.jenkins.plugins.pipeline.model.ITimedOpenShiftPlugin;
import com.openshift.jenkins.plugins.pipeline.model.RetryIClient;
import com.openshift.restclient.ClientBuilder;
import com.openshift.restclient.IClient;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.api.capabilities.IPodExec;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.IStoppable;
import com.openshift.restclient.model.IPod;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public interface IOpenShiftExec
extends ITimedOpenShiftPlugin,
IPodExec.IPodExecOutputListener {
    public static final String DISPLAY_NAME = "OpenShift Exec";

    public String getPod();

    default public String getPod(Map<String, String> overrides) {
        return this.getOverride(this.getPod(), overrides);
    }

    public String getContainer();

    default public String getContainer(Map<String, String> overrides) {
        return this.getOverride(this.getContainer(), overrides);
    }

    public String getCommand();

    default public String getCommand(Map<String, String> overrides) {
        return this.getOverride(this.getCommand(), overrides);
    }

    public List<Argument> getArguments();

    default public List<Argument> getArguments(Map<String, String> overrides) {
        ArrayList<Argument> subs = new ArrayList<Argument>();
        List<Argument> args = this.getArguments();
        if (args != null) {
            args.forEach(a -> subs.add(new Argument(this.getOverride(a.getValue(), overrides))));
        }
        return subs;
    }

    @Override
    default public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    default public long getGlobalTimeoutConfiguration() {
        return GlobalConfig.getExecWait();
    }

    @Override
    default public IClient getClient(TaskListener listener, String displayName, Map<String, String> overrides, String token) {
        IClient client;
        Auth auth = this.getAuth();
        ClientBuilder cb = null;
        long timeoutInMS = this.getTimeout(listener, Boolean.parseBoolean(this.getVerbose(overrides)), overrides);
        if (timeoutInMS > Integer.MAX_VALUE) {
            int timeoutInMin = (int)(timeoutInMS / 60000L);
            cb = new ClientBuilder(this.getApiURL(overrides)).sslCertificateCallback((ISSLCertificateCallback)auth).withReadTimeout(timeoutInMin, TimeUnit.MINUTES).withWriteTimeout(timeoutInMin, TimeUnit.MINUTES).withConnectTimeout(timeoutInMin, TimeUnit.MINUTES).usingToken(token).sslCertificateCollection(this.getApiURL(overrides), auth.getCerts());
        } else {
            cb = new ClientBuilder(this.getApiURL(overrides)).sslCertificateCallback((ISSLCertificateCallback)auth).withReadTimeout((int)timeoutInMS, TimeUnit.MILLISECONDS).withWriteTimeout((int)timeoutInMS, TimeUnit.MILLISECONDS).withConnectTimeout((int)timeoutInMS, TimeUnit.MILLISECONDS).usingToken(token).sslCertificateCollection(this.getApiURL(overrides), auth.getCerts());
        }
        if (auth.useCert()) {
            cb.sslCertCallbackWithDefaultHostnameVerifier(true);
        }
        if ((client = cb.build()) == null) {
            listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; a client connection to \"%s\" could not be obtained.", displayName, this.getApiURL(overrides)));
        }
        return new RetryIClient(client, listener);
    }

    @Override
    default public boolean coreLogic(Launcher launcher, final TaskListener listener, Map<String, String> overrides) {
        IClient client;
        boolean chatty = Boolean.parseBoolean(this.getVerbose(overrides));
        listener.getLogger().println(String.format("\n\nStarting \"%s\" with project \"%s\".", DISPLAY_NAME, this.getNamespace(overrides)));
        final ArrayList<String> fullCommand = new ArrayList<String>();
        fullCommand.add(this.getCommand(overrides));
        List<Argument> arguments = this.getArguments(overrides);
        if (arguments != null) {
            arguments.forEach(a -> fullCommand.add(a.getValue()));
        }
        final IPodExec.Options options = new IPodExec.Options();
        if (!this.getContainer(overrides).isEmpty()) {
            options.container(this.getContainer(overrides));
        }
        if ((client = this.getClient(listener, DISPLAY_NAME, overrides)) == null) {
            listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully: %s", DISPLAY_NAME, "Unable to obtain rest client"));
            return false;
        }
        long remainingWaitTime = this.getTimeout(listener, chatty, overrides);
        int LOOP_DELAY = 1000;
        IPod p = null;
        int retries = 10;
        while (p == null) {
            try {
                p = (IPod)client.get("Pod", this.getPod(overrides), this.getNamespace(overrides));
            }
            catch (Exception e) {
                if (retries == 1 || remainingWaitTime < 0L) {
                    listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully: %s", DISPLAY_NAME, "Unable to find pod: " + this.getPod(overrides)));
                    e.printStackTrace(listener.getLogger());
                    return false;
                }
                try {
                    Thread.sleep(1000L);
                    remainingWaitTime -= 1000L;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            --retries;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean reportError = new AtomicBoolean(false);
        IStoppable exec = (IStoppable)p.accept((CapabilityVisitor)new CapabilityVisitor<IPodExec, IStoppable>(){

            public IStoppable visit(IPodExec capability) {
                return capability.start(new IPodExec.IPodExecOutputListener(){

                    public void onOpen() {
                        listener.getLogger().println("Connection opened for exec operation");
                        IOpenShiftExec.this.onOpen();
                    }

                    public void onStdOut(String message) {
                        listener.getLogger().println("stdout> " + message);
                        IOpenShiftExec.this.onStdOut(message);
                    }

                    public void onStdErr(String message) {
                        listener.getLogger().println("stderr> " + message);
                        IOpenShiftExec.this.onStdErr(message);
                    }

                    public void onExecErr(String message) {
                        reportError.set(true);
                        listener.error("Error during exec: " + message);
                        IOpenShiftExec.this.onExecErr(message);
                    }

                    public void onClose(int code, String reason) {
                        listener.getLogger().printf("Connection closed for exec operation [%d]: %s\n", code, reason);
                        IOpenShiftExec.this.onClose(code, reason);
                        latch.countDown();
                    }

                    public void onFailure(IOException e) {
                        reportError.set(true);
                        listener.error("Failure during exec: " + e.getMessage());
                        IOpenShiftExec.this.onFailure(e);
                        e.printStackTrace();
                        latch.countDown();
                    }
                }, options, fullCommand.toArray(new String[0]));
            }
        }, null);
        boolean timeout = true;
        try {
            timeout = !latch.await(Math.max(remainingWaitTime, 1L), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (timeout) {
            listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; the api did not return in time.", DISPLAY_NAME));
            return false;
        }
        if (reportError.get()) {
            listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; the API response included an error or failure.", DISPLAY_NAME));
            return false;
        }
        listener.getLogger().println(String.format("\n\nExiting \"%s\" successfully.", DISPLAY_NAME));
        return true;
    }

    default public void onOpen() {
    }

    default public void onStdOut(String message) {
    }

    default public void onStdErr(String message) {
    }

    default public void onExecErr(String message) {
    }

    default public void onClose(int code, String reason) {
    }

    default public void onFailure(IOException e) {
    }
}

