/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.jenkins.plugins.pipeline.OpenShiftDeployCanceller;
import com.openshift.jenkins.plugins.pipeline.model.GlobalConfig;
import com.openshift.jenkins.plugins.pipeline.model.ITimedOpenShiftPlugin;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IReplicationController;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public interface IOpenShiftDeploymentVerification
extends ITimedOpenShiftPlugin {
    public static final String DISPLAY_NAME = "Verify OpenShift Deployment";

    @Override
    default public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getDepCfg();

    public String getReplicaCount();

    public String getVerifyReplicaCount();

    @Override
    default public long getGlobalTimeoutConfiguration() {
        return GlobalConfig.getDeployVerifyWait();
    }

    default public String getDepCfg(Map<String, String> overrides) {
        return this.getOverride(this.getDepCfg(), overrides);
    }

    default public String getReplicaCount(Map<String, String> overrides) {
        return this.getOverride(this.getReplicaCount(), overrides);
    }

    default public String getVerifyReplicaCount(Map<String, String> overrides) {
        return this.getOverride(this.getVerifyReplicaCount(), overrides);
    }

    @Override
    default public boolean coreLogic(Launcher launcher, TaskListener listener, Map<String, String> overrides) throws InterruptedException {
        boolean chatty = Boolean.parseBoolean(this.getVerbose(overrides));
        boolean checkCount = Boolean.parseBoolean(this.getVerifyReplicaCount(overrides));
        listener.getLogger().println(String.format("\n\nStarting \"%s\" with deployment config \"%s\" from the project \"%s\".", DISPLAY_NAME, this.getDepCfg(overrides), this.getNamespace(overrides)));
        IClient client = this.getClient(listener, DISPLAY_NAME, overrides);
        if (client != null) {
            int count = -1;
            if (checkCount && this.getReplicaCount(overrides) != null && this.getReplicaCount(overrides).length() > 0) {
                count = Integer.parseInt(this.getReplicaCount(overrides));
            }
            if (!checkCount) {
                listener.getLogger().println(String.format("  Waiting on the latest deployment for \"%s\" to complete ...", this.getDepCfg(overrides)));
            } else {
                listener.getLogger().println(String.format("  Waiting on the latest deployment for \"%s\" to complete and scale to \"%s\" replica(s) ...", this.getDepCfg(overrides), this.getReplicaCount(overrides)));
            }
            long currTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            String state = null;
            String depId = null;
            boolean scaledAppropriately = false;
            long wait = this.getTimeout(listener, chatty, overrides);
            while (TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) < currTime + wait) {
                IDeploymentConfig dc = (IDeploymentConfig)client.get("DeploymentConfig", this.getDepCfg(overrides), this.getNamespace(overrides));
                if (dc != null) {
                    IReplicationController rc;
                    if (checkCount && count == -1) {
                        count = dc.getReplicas();
                    }
                    if (chatty) {
                        listener.getLogger().println("\nOpenShiftDeploymentVerifier latest version:  " + dc.getLatestVersionNumber());
                    }
                    if ((rc = this.getLatestReplicationController(dc, this.getNamespace(overrides), client, (TaskListener)(chatty ? listener : null))) != null) {
                        if (chatty) {
                            listener.getLogger().println("\nOpenShiftDeploymentVerifier current rc " + rc);
                        }
                        if (this.isDeployFinished(state = this.getReplicationControllerState(rc))) {
                            depId = rc.getName();
                            if (state.equalsIgnoreCase("Failed")) {
                                listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; deployment \"%s\" has completed with status:  [%s].", DISPLAY_NAME, this.getDepCfg(overrides), state));
                                return false;
                            }
                            if (chatty) {
                                listener.getLogger().println("\nOpenShiftDeploymentVerifier rc current count " + rc.getCurrentReplicaCount() + " rc desired count " + rc.getDesiredReplicaCount() + " step verification amount " + count + " current state " + state + " and check count " + checkCount);
                            }
                            if (scaledAppropriately = this.isReplicationControllerScaledAppropriately(rc, checkCount, count)) {
                                break;
                            }
                        } else if (chatty) {
                            listener.getLogger().println("\nOpenShiftDeploymentVerifier current phase " + state);
                        }
                    } else if (chatty) {
                        listener.getLogger().println("\nOpenShiftDeploymenVerifier no rc for latest version yet");
                    }
                } else {
                    listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; the deployment config \"%s\" could not be read.", DISPLAY_NAME, this.getDepCfg(overrides)));
                    return false;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    OpenShiftDeployCanceller canceller = new OpenShiftDeployCanceller(this.getApiURL(overrides), this.getDepCfg(overrides), this.getNamespace(overrides), this.getAuthToken(overrides), this.getVerbose(overrides));
                    canceller.setAuth(this.getAuth());
                    canceller.coreLogic(null, listener, overrides);
                    throw e;
                }
            }
            if (scaledAppropriately) {
                if (!checkCount) {
                    listener.getLogger().println(String.format("\n\nExiting \"%s\" successfully; deployment \"%s\" has completed with status:  [Complete].", DISPLAY_NAME, depId));
                } else {
                    listener.getLogger().println(String.format("\n\nExiting \"%s\" successfully; deployment \"%s\" has completed with status:  [Complete].  The deployment reached \"%s\" replica(s).", DISPLAY_NAME, depId, count));
                }
                return true;
            }
            if (checkCount) {
                listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; deployment \"%s\" has completed with status:  [%s].  And the replica count was \"%s\".", DISPLAY_NAME, depId, state, this.getReplicaCount(overrides)));
            } else {
                listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; deployment \"%s\" has completed with status:  [%s].", DISPLAY_NAME, depId, state));
            }
            return false;
        }
        return false;
    }
}

