/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.jenkins.plugins.pipeline.OpenShiftDeployCanceller;
import com.openshift.jenkins.plugins.pipeline.model.GlobalConfig;
import com.openshift.jenkins.plugins.pipeline.model.ITimedOpenShiftPlugin;
import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IDeploymentTriggerable;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public interface IOpenShiftDeployer
extends ITimedOpenShiftPlugin {
    public static final String DISPLAY_NAME = "Trigger OpenShift Deployment";

    @Override
    default public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getDepCfg();

    @Override
    default public long getGlobalTimeoutConfiguration() {
        return GlobalConfig.getDeployWait();
    }

    default public String getDepCfg(Map<String, String> overrides) {
        return this.getOverride(this.getDepCfg(), overrides);
    }

    @Override
    default public boolean coreLogic(Launcher launcher, TaskListener listener, Map<String, String> overrides) throws InterruptedException {
        boolean chatty = Boolean.parseBoolean(this.getVerbose(overrides));
        listener.getLogger().println(String.format("\n\nStarting \"%s\" with deployment config \"%s\" from the project \"%s\".", DISPLAY_NAME, this.getDepCfg(overrides), this.getNamespace(overrides)));
        IClient client = this.getClient(listener, DISPLAY_NAME, overrides);
        if (client != null) {
            long currTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            boolean deployDone = false;
            boolean versionBumped = false;
            String state = null;
            IDeploymentConfig dc = null;
            IDeploymentConfig newdc = null;
            IReplicationController rc = null;
            long wait = this.getTimeout(listener, chatty, overrides);
            while (TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) < currTime + wait) {
                block25: {
                    block24: {
                        if (dc == null) {
                            dc = (IDeploymentConfig)client.get("DeploymentConfig", this.getDepCfg(overrides), this.getNamespace(overrides));
                        }
                        if (dc == null) continue;
                        if (!versionBumped) {
                            try {
                                final String dcName = dc.getName();
                                newdc = (IDeploymentConfig)dc.accept((CapabilityVisitor)new CapabilityVisitor<IDeploymentTriggerable, IDeploymentConfig>(){

                                    public IDeploymentConfig visit(IDeploymentTriggerable triggerable) {
                                        triggerable.setForce(true);
                                        triggerable.setLatest(true);
                                        triggerable.setResourceName(dcName);
                                        return triggerable.trigger();
                                    }
                                }, null);
                                if (chatty) {
                                    listener.getLogger().println("\nOpenShiftDeployer latest version now " + newdc.getLatestVersionNumber() + " and was " + dc.getLatestVersionNumber());
                                }
                                versionBumped = newdc.getLatestVersionNumber() > dc.getLatestVersionNumber();
                            }
                            catch (Throwable t) {
                                if (!chatty) break block24;
                                t.printStackTrace(listener.getLogger());
                            }
                        }
                    }
                    try {
                        rc = this.getLatestReplicationController(newdc, this.getNamespace(overrides), client, (TaskListener)(chatty ? listener : null));
                        if (chatty) {
                            listener.getLogger().println("\nOpenShiftDeployer returned rep ctrl " + rc);
                        }
                        if (rc != null) {
                            this.annotateJobInfoToResource(client, listener, chatty, overrides, (IResource)rc);
                            state = this.getReplicationControllerState(rc);
                            if (this.isDeployFinished(state)) {
                                if (state.equalsIgnoreCase("Failed")) {
                                    listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; deployment \"%s\" has completed with status:  [%s].", DISPLAY_NAME, rc.getName(), state));
                                    return false;
                                }
                                if (state.equalsIgnoreCase("Complete")) {
                                    deployDone = true;
                                }
                            } else if (chatty) {
                                listener.getLogger().println("\nOpenShiftDeploy current phase " + state);
                            }
                        } else if (chatty) {
                            listener.getLogger().println("\nOpenShiftDeploy no rc for latest version yet");
                        }
                    }
                    catch (Throwable t) {
                        if (!chatty) break block25;
                        t.printStackTrace(listener.getLogger());
                    }
                }
                if (deployDone) break;
                if (chatty) {
                    listener.getLogger().println("\nOpenShiftDeployer wait 10 seconds, then try oc deploy again");
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    OpenShiftDeployCanceller canceller = new OpenShiftDeployCanceller(this.getApiURL(overrides), this.getDepCfg(overrides), this.getNamespace(overrides), this.getAuthToken(overrides), this.getVerbose(overrides));
                    canceller.setAuth(this.getAuth());
                    canceller.coreLogic(null, listener, overrides);
                    throw e;
                }
            }
            if (!deployDone) {
                if (newdc != null) {
                    listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; gave up on deployment \"%s\" with status:  [%s].", DISPLAY_NAME, rc != null ? rc.getName() : "<deployment not found>", state));
                } else {
                    listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; the deployment config \"%s\" could not be read.", DISPLAY_NAME, this.getDepCfg(overrides)));
                }
                return false;
            }
            listener.getLogger().println(String.format("\n\nExiting \"%s\" successfully; deployment \"%s\" has completed with status:  [Complete].", DISPLAY_NAME, rc.getName()));
            return true;
        }
        return false;
    }
}

