/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.jenkins.plugins.pipeline.OpenShiftApiObjHandler;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftApiObjHandler;
import com.openshift.restclient.IClient;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.util.Map;
import java.util.Set;

public interface IOpenShiftDeleterList
extends IOpenShiftApiObjHandler {
    public static final String DISPLAY_NAME = "Delete OpenShift Resource(s) by Key";

    @Override
    default public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getKeys();

    public String getTypes();

    default public String getTypes(Map<String, String> overrides) {
        return this.getOverride(this.getTypes(), overrides);
    }

    default public String getKeys(Map<String, String> overrides) {
        return this.getOverride(this.getKeys(), overrides);
    }

    @Override
    default public boolean coreLogic(Launcher launcher, TaskListener listener, Map<String, String> overrides) {
        boolean chatty = Boolean.parseBoolean(this.getVerbose(overrides));
        listener.getLogger().println(String.format("\n\nStarting \"%s\" with the project \"%s\".", DISPLAY_NAME, this.getNamespace(overrides)));
        this.updateApiTypes(chatty, listener, overrides);
        IClient client = this.getClient(listener, DISPLAY_NAME, overrides);
        if (client != null) {
            String[] inputKeys;
            Set<String> types = OpenShiftApiObjHandler.apiMap.keySet();
            String resourceKind = null;
            int deletes = 0;
            int fails = 0;
            int badType = 0;
            String[] inputTypes = this.getTypes(overrides).split(",");
            if (inputTypes.length != (inputKeys = this.getKeys(overrides).split(",")).length) {
                listener.getLogger().println(String.format("\n\nExiting \"Delete OpenShift Resource(s) by Key\" unsuccessfully, because %d types(s) were specified but %d keys(s) were specified.", inputTypes.length, inputKeys.length));
                return false;
            }
            for (int i = 0; i < inputTypes.length; ++i) {
                if (OpenShiftApiObjHandler.typeShortcut.containsKey(inputTypes[i])) {
                    resourceKind = OpenShiftApiObjHandler.typeShortcut.get(inputTypes[i]);
                } else {
                    for (String type : types) {
                        if (!type.equalsIgnoreCase(inputTypes[i])) continue;
                        resourceKind = type;
                        break;
                    }
                }
                if (resourceKind == null) {
                    listener.getLogger().println(String.format("  The API resource \"%s\" is not currently supported by this step.", inputTypes[i]));
                    ++badType;
                    continue;
                }
                int[] rc = new int[2];
                rc = this.deleteAPIObjs(client, listener, this.getNamespace(overrides), resourceKind, inputKeys[i], null, chatty);
                deletes += rc[0];
                fails += rc[1];
            }
            if (fails == 0 && badType == 0) {
                listener.getLogger().println(String.format("\n\nExiting \"%s\" successfully, with %d resource(s) deleted.", DISPLAY_NAME, deletes));
                return true;
            }
            listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully, with %d resource(s) deleted and %d failed attempt(s).", DISPLAY_NAME, deletes, fails + badType));
        }
        return false;
    }
}

