/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftApiObjHandler;
import com.openshift.restclient.IClient;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public interface IOpenShiftDeleterJsonYaml
extends IOpenShiftApiObjHandler {
    public static final String DISPLAY_NAME = "Delete OpenShift Resource(s) from JSON or YAML";
    public static final String UNDEFINED = "undefined";

    @Override
    default public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getJsonyaml();

    default public String getJsonyaml(Map<String, String> overrides) {
        return this.getOverride(this.getJsonyaml(), overrides);
    }

    @Override
    default public boolean coreLogic(Launcher launcher, TaskListener listener, Map<String, String> overrides) {
        boolean chatty = Boolean.parseBoolean(this.getVerbose(overrides));
        listener.getLogger().println(String.format("\n\nStarting \"%s\" with the project \"%s\".", DISPLAY_NAME, this.getNamespace(overrides)));
        this.updateApiTypes(chatty, listener, overrides);
        ModelNode resources = this.hydrateJsonYaml(this.getJsonyaml(overrides), (TaskListener)(chatty ? listener : null));
        if (resources == null) {
            return false;
        }
        IClient client = this.getClient(listener, DISPLAY_NAME, overrides);
        if (client != null) {
            String kind = resources.get("kind").asString();
            int deletes = 0;
            int fails = 0;
            if (kind.equalsIgnoreCase("List")) {
                List list = resources.get("items").asList();
                for (ModelNode node : list) {
                    String path = node.get("kind").asString();
                    String name = node.get("metadata").get("name").asString();
                    String namespace = node.get("metadata").get("namespace").asString();
                    if (UNDEFINED.equals(namespace)) {
                        namespace = this.getNamespace(overrides);
                    }
                    int[] rc = new int[2];
                    rc = this.deleteAPIObjs(client, listener, namespace, path, name, null, chatty);
                    deletes += rc[0];
                    fails += rc[1];
                }
            } else {
                String path = kind;
                String name = resources.get("metadata").get("name").asString();
                String namespace = resources.get("metadata").get("namespace").asString();
                if (UNDEFINED.equals(namespace)) {
                    namespace = this.getNamespace(overrides);
                }
                int[] rc = new int[2];
                rc = this.deleteAPIObjs(client, listener, namespace, path, name, null, chatty);
                deletes += rc[0];
                fails += rc[1];
            }
            if (fails > 0) {
                listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully, with %d resource(s) deleted and %d failed attempt(s).", DISPLAY_NAME, deletes, fails));
                return false;
            }
            listener.getLogger().println(String.format("\n\nExiting \"%s\" successfully, with %d resource(s) deleted.", DISPLAY_NAME, deletes));
            return true;
        }
        return false;
    }
}

