/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.jenkins.plugins.pipeline.OpenShiftApiObjHandler;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftApiObjHandler;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IResource;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public interface IOpenShiftCreator
extends IOpenShiftApiObjHandler {
    public static final String DISPLAY_NAME = "Create OpenShift Resource(s)";
    public static final String UNDEFINED = "undefined";

    @Override
    default public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getJsonyaml();

    default public String getJsonyaml(Map<String, String> overrides) {
        return this.getOverride(this.getJsonyaml(), overrides);
    }

    default public boolean makeRESTCall(boolean chatty, TaskListener listener, String path, ModelNode resource, Map<String, String> overrides) {
        if (OpenShiftApiObjHandler.apiMap.get(path) == null) {
            listener.getLogger().println(String.format("  The API resource \"%s\" is not currently supported by this step.", path));
            return false;
        }
        String namespace = resource.get("metadata").get("namespace").asString();
        boolean setOnResource = false;
        if (UNDEFINED.equals(namespace)) {
            namespace = this.getNamespace(overrides);
        } else {
            setOnResource = true;
        }
        IClient client = this.getClient(listener, DISPLAY_NAME, overrides);
        if (client == null) {
            return false;
        }
        KubernetesResource kr = new KubernetesResource(resource, client, null);
        if (setOnResource) {
            kr.setNamespace(namespace);
        }
        if (chatty) {
            listener.getLogger().println("\nOpenShiftCreator calling create on for type " + OpenShiftApiObjHandler.apiMap.get(path)[1] + " and resource " + kr.toJson(false));
        }
        client.execute("POST", OpenShiftApiObjHandler.apiMap.get(path)[1], namespace, null, null, (IResource)kr);
        return true;
    }

    @Override
    default public boolean coreLogic(Launcher launcher, TaskListener listener, Map<String, String> overrides) {
        boolean chatty = Boolean.parseBoolean(this.getVerbose(overrides));
        listener.getLogger().println(String.format("\n\nStarting \"Create OpenShift Resource(s)\" with the project \"%s\".", this.getNamespace(overrides)));
        this.updateApiTypes(chatty, listener, overrides);
        ModelNode resources = this.hydrateJsonYaml(this.getJsonyaml(overrides), (TaskListener)(chatty ? listener : null));
        if (resources == null) {
            return false;
        }
        String kind = resources.get("kind").asString();
        int created = 0;
        int failed = 0;
        if (kind.equalsIgnoreCase("List")) {
            List list = resources.get("items").asList();
            for (ModelNode node : list) {
                boolean success;
                String path;
                block12: {
                    path = node.get("kind").asString();
                    success = false;
                    try {
                        success = this.makeRESTCall(chatty, listener, path, node, overrides);
                    }
                    catch (Throwable t) {
                        if (!chatty) break block12;
                        t.printStackTrace(listener.getLogger());
                    }
                }
                if (!success) {
                    listener.getLogger().println(String.format("  Failed to create a \"%s\"", path));
                    ++failed;
                    continue;
                }
                listener.getLogger().println(String.format("  Created a \"%s\"", path));
                ++created;
            }
        } else {
            boolean success;
            String path;
            block13: {
                path = kind;
                success = false;
                try {
                    success = this.makeRESTCall(chatty, listener, path, resources, overrides);
                }
                catch (Throwable t) {
                    if (!chatty) break block13;
                    t.printStackTrace(listener.getLogger());
                }
            }
            if (success) {
                listener.getLogger().println(String.format("  Created a \"%s\"", path));
                created = 1;
            } else {
                listener.getLogger().println(String.format("  Failed to create a \"%s\"", path));
                failed = 1;
            }
        }
        if (failed > 0) {
            listener.getLogger().println(String.format("\n\nExiting \"Create OpenShift Resource(s)\" unsuccessfully, with %d resource(s) created and %d failed attempt(s).", created, failed));
            return false;
        }
        listener.getLogger().println(String.format("\n\nExiting \"Create OpenShift Resource(s)\" successfully, with %d resource(s) created.", created));
        return true;
    }
}

