/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.jenkins.plugins.pipeline.NameValuePair;
import com.openshift.jenkins.plugins.pipeline.OpenShiftBuildCanceller;
import com.openshift.jenkins.plugins.pipeline.model.GlobalConfig;
import com.openshift.jenkins.plugins.pipeline.model.ITimedOpenShiftPlugin;
import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.IStoppable;
import com.openshift.restclient.capability.resources.IBuildTriggerable;
import com.openshift.restclient.capability.resources.IPodLogRetrievalAsync;
import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IContainer;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IResource;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public interface IOpenShiftBuilder
extends ITimedOpenShiftPlugin {
    public static final String DISPLAY_NAME = "Trigger OpenShift Build";

    @Override
    default public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getCommitID();

    public String getBuildName();

    public String getShowBuildLogs();

    public String getBldCfg();

    public String getCheckForTriggeredDeployments();

    public List<NameValuePair> getEnv();

    default public String getCommitID(Map<String, String> overrides) {
        return this.getOverride(this.getCommitID(), overrides);
    }

    default public String getBuildName(Map<String, String> overrides) {
        return this.getOverride(this.getBuildName(), overrides);
    }

    default public String getShowBuildLogs(Map<String, String> overrides) {
        return this.getOverride(this.getShowBuildLogs(), overrides);
    }

    default public String getBldCfg(Map<String, String> overrides) {
        return this.getOverride(this.getBldCfg(), overrides);
    }

    default public String getCheckForTriggeredDeployments(Map<String, String> overrides) {
        return this.getOverride(this.getCheckForTriggeredDeployments(), overrides);
    }

    @Override
    default public long getGlobalTimeoutConfiguration() {
        return GlobalConfig.getBuildWait();
    }

    default public void applyEnvVars(IBuildTriggerable bt, Map<String, String> overrides, TaskListener listener, boolean chatty) {
        if (this.getEnv() != null) {
            for (NameValuePair p : this.getEnv()) {
                String name = p.getName().trim();
                if (name.isEmpty()) continue;
                if (chatty) {
                    listener.getLogger().println("applyEnvVars env name " + name + " raw value " + p.getValue() + " override value " + this.getOverride(p.getValue(), overrides));
                }
                bt.setEnvironmentVariable(p.getName(), this.getOverride(p.getValue(), overrides));
            }
        }
    }

    default public IBuild startBuild(IBuildConfig bc, IBuild prevBld, final Map<String, String> overrides, final boolean chatty, final TaskListener listener, IClient client) {
        IBuild bld = null;
        if (bc != null) {
            if (this.getCommitID(overrides) != null && this.getCommitID(overrides).length() > 0) {
                final String cid = this.getCommitID(overrides);
                bld = (IBuild)bc.accept((CapabilityVisitor)new CapabilityVisitor<IBuildTriggerable, IBuild>(){

                    public IBuild visit(IBuildTriggerable triggerable) {
                        triggerable.setCommitId(cid);
                        triggerable.addBuildCause("Jenkins job: " + (String)overrides.get("BUILD_URL"));
                        IOpenShiftBuilder.this.applyEnvVars(triggerable, overrides, listener, chatty);
                        return triggerable.trigger();
                    }
                }, null);
            } else {
                bld = (IBuild)bc.accept((CapabilityVisitor)new CapabilityVisitor<IBuildTriggerable, IBuild>(){

                    public IBuild visit(IBuildTriggerable triggerable) {
                        triggerable.addBuildCause("Jenkins job: " + (String)overrides.get("BUILD_URL"));
                        IOpenShiftBuilder.this.applyEnvVars(triggerable, overrides, listener, chatty);
                        return triggerable.trigger();
                    }
                }, null);
            }
        } else if (prevBld != null) {
            bld = (IBuild)prevBld.accept((CapabilityVisitor)new CapabilityVisitor<IBuildTriggerable, IBuild>(){

                public IBuild visit(IBuildTriggerable triggerable) {
                    triggerable.addBuildCause("Jenkins job: " + (String)overrides.get("BUILD_URL"));
                    IOpenShiftBuilder.this.applyEnvVars(triggerable, overrides, listener, chatty);
                    return triggerable.trigger();
                }
            }, null);
        }
        return bld;
    }

    default public IStoppable getBuildPodLogs(IClient client, String bldId, Map<String, String> overrides, boolean chatty, final TaskListener listener, final AtomicBoolean needToFollow) {
        IStoppable stop = null;
        List pods = client.list("Pod", this.getNamespace(overrides));
        for (IPod pod : pods) {
            if (chatty) {
                listener.getLogger().println("\nOpenShiftBuilder found pod " + pod.getName());
            }
            if (!pod.getName().startsWith(bldId)) continue;
            if (chatty) {
                listener.getLogger().println("\nOpenShiftBuilder going with build pod " + pod);
            }
            final String container = ((IContainer)pod.getContainers().iterator().next()).getName();
            stop = (IStoppable)pod.accept((CapabilityVisitor)new CapabilityVisitor<IPodLogRetrievalAsync, IStoppable>(){

                public IStoppable visit(IPodLogRetrievalAsync capability) {
                    return capability.start(new IPodLogRetrievalAsync.IPodLogListener(){

                        public void onOpen() {
                        }

                        public void onMessage(String message) {
                            listener.getLogger().print(message);
                        }

                        public void onClose(int code, String reason) {
                        }

                        public void onFailure(IOException e) {
                            needToFollow.compareAndSet(false, true);
                        }
                    }, new IPodLogRetrievalAsync.Options().follow().container(container));
                }
            }, null);
            break;
        }
        return stop;
    }

    default public void waitOnBuild(IClient client, long startTime, String bldId, TaskListener listener, Map<String, String> overrides, long wait, boolean follow, boolean chatty) throws InterruptedException {
        IBuild bld = null;
        String bldState = null;
        IStoppable stop = null;
        AtomicBoolean needToFollow = new AtomicBoolean(follow);
        while (TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) < startTime + wait) {
            bld = (IBuild)client.get("Build", bldId, this.getNamespace(overrides));
            bldState = bld.getStatus();
            if (Boolean.parseBoolean(this.getVerbose(overrides))) {
                listener.getLogger().println("\nOpenShiftBuilder bld state:  " + bldState);
            }
            if (this.isBuildRunning(bldState) && needToFollow.compareAndSet(true, false)) {
                stop = this.getBuildPodLogs(client, bldId, overrides, chatty, listener, needToFollow);
            }
            if (this.isBuildFinished(bldState)) {
                if (!follow || stop != null) break;
                stop = this.getBuildPodLogs(client, bldId, overrides, chatty, listener, needToFollow);
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                OpenShiftBuildCanceller canceller = new OpenShiftBuildCanceller(this.getApiURL(overrides), this.getNamespace(overrides), this.getAuthToken(overrides), this.getVerbose(overrides), this.getBldCfg(overrides));
                canceller.setAuth(this.getAuth());
                canceller.coreLogic(null, listener, overrides);
                throw e;
            }
        }
        if (stop != null) {
            stop.stop();
        }
    }

    @Override
    default public boolean coreLogic(Launcher launcher, TaskListener listener, Map<String, String> overrides) throws InterruptedException {
        IClient client;
        boolean chatty = Boolean.parseBoolean(this.getVerbose(overrides));
        boolean checkDeps = Boolean.parseBoolean(this.getCheckForTriggeredDeployments(overrides));
        listener.getLogger().println(String.format("\n\nStarting the \"%s\" step with build config \"%s\" from the project \"%s\".", DISPLAY_NAME, this.getBldCfg(overrides), this.getNamespace(overrides)));
        boolean follow = Boolean.parseBoolean(this.getShowBuildLogs(overrides));
        if (chatty) {
            listener.getLogger().println("\nOpenShiftBuilder logger follow " + follow);
        }
        if ((client = this.getClient(listener, DISPLAY_NAME, overrides)) != null) {
            long startTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            boolean skipBC = this.getBuildName(overrides) != null && this.getBuildName(overrides).length() > 0;
            IBuildConfig bc = null;
            IBuild prevBld = null;
            if (!skipBC) {
                bc = (IBuildConfig)client.get("BuildConfig", this.getBldCfg(overrides), this.getNamespace(overrides));
            } else {
                prevBld = (IBuild)client.get("Build", this.getBuildName(overrides), this.getNamespace(overrides));
            }
            if (chatty) {
                listener.getLogger().println("\nOpenShiftBuilder build config retrieved " + bc + " buildName " + this.getBuildName(overrides));
            }
            if (bc != null || prevBld != null) {
                IBuild bld;
                boolean jenkinsfileBC = false;
                if (bc != null) {
                    jenkinsfileBC = bc.getBuildStrategy() == null;
                } else {
                    IBuildConfig tmpBC = (IBuildConfig)client.get("BuildConfig", this.getBldCfg(overrides), this.getNamespace(overrides));
                    if (tmpBC != null) {
                        boolean bl = jenkinsfileBC = tmpBC.getBuildStrategy() == null;
                    }
                }
                if (chatty) {
                    listener.getLogger().println("\nOpenShiftBuilder bc strategy == jenkinsfile " + jenkinsfileBC);
                }
                if (follow) {
                    boolean bl = follow = !jenkinsfileBC;
                }
                if ((bld = this.startBuild(bc, prevBld, overrides, chatty, listener, client)) == null) {
                    listener.getLogger().println("\n\nExiting \"Trigger OpenShift Build\" unsuccessfully; could not retrieve the associated Build object from the start build command.");
                    return false;
                }
                this.annotateJobInfoToResource(client, listener, chatty, overrides, (IResource)bld);
                String bldId = bld.getName();
                if (!checkDeps) {
                    listener.getLogger().println(String.format("  Started build \"%s\" and waiting for build completion ...", bldId));
                } else {
                    listener.getLogger().println(String.format("  Started build \"%s\" and waiting for build completion followed by a new deployment ...", bldId));
                }
                startTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                long wait = this.getTimeout(listener, chatty, overrides);
                if (chatty) {
                    listener.getLogger().println("\n OpenShiftBuilder looking for build " + bldId);
                }
                this.waitOnBuild(client, startTime, bldId, listener, overrides, wait, follow, chatty);
                return this.verifyBuild(startTime, wait, client, this.getBldCfg(overrides), bldId, this.getNamespace(overrides), chatty, listener, DISPLAY_NAME, checkDeps, true, overrides);
            }
            listener.getLogger().println(String.format("\n\nExiting \"Trigger OpenShift Build\" unsuccessfully; the build config \"%s\" could not be read.", this.getBldCfg(overrides)));
            return false;
        }
        return false;
    }
}

