/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.jenkins.plugins.pipeline.model.GlobalConfig;
import com.openshift.jenkins.plugins.pipeline.model.ITimedOpenShiftPlugin;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IBuild;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public interface IOpenShiftBuildVerifier
extends ITimedOpenShiftPlugin {
    public static final String DISPLAY_NAME = "Verify OpenShift Build";

    @Override
    default public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getBldCfg();

    public String getCheckForTriggeredDeployments();

    @Override
    default public long getGlobalTimeoutConfiguration() {
        return GlobalConfig.getBuildVerifyWait();
    }

    default public String getBldCfg(Map<String, String> overrides) {
        return this.getOverride(this.getBldCfg(), overrides);
    }

    default public String getCheckForTriggeredDeployments(Map<String, String> overrides) {
        return this.getOverride(this.getCheckForTriggeredDeployments(), overrides);
    }

    default public String getLatestBuildID(IClient client, Map<String, String> overrides) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("openshift.io/build-config.name", this.getBldCfg(overrides));
        List blds = client.list("Build", this.getNamespace(overrides), filter);
        ArrayList<String> starttimes = new ArrayList<String>();
        HashMap<String, String> timeToID = new HashMap<String, String>();
        Collections.sort(blds, new BuildNameComparator());
        for (IBuild bld : blds) {
            starttimes.add(bld.getBuildStatus().getStartTime());
            timeToID.put(bld.getBuildStatus().getStartTime(), bld.getName());
        }
        String starttime = null;
        if (starttimes.size() > 0) {
            Collections.sort(starttimes);
            starttime = (String)starttimes.get(starttimes.size() - 1);
        }
        return (String)timeToID.get(starttime);
    }

    @Override
    default public boolean coreLogic(Launcher launcher, TaskListener listener, Map<String, String> overrides) throws InterruptedException {
        boolean chatty = Boolean.parseBoolean(this.getVerbose(overrides));
        boolean checkDeps = Boolean.parseBoolean(this.getCheckForTriggeredDeployments(overrides));
        listener.getLogger().println(String.format("\n\nStarting the \"%s\" step with build config \"%s\" from the project \"%s\".", DISPLAY_NAME, this.getBldCfg(overrides), this.getNamespace(overrides)));
        IClient client = this.getClient(listener, DISPLAY_NAME, overrides);
        if (client != null) {
            String bldId = this.getLatestBuildID(client, overrides);
            if (!checkDeps) {
                listener.getLogger().println(String.format("  Waiting on build \"%s\" to complete ...", bldId));
            } else {
                listener.getLogger().println(String.format("  Waiting on build \"%s\" to complete followed by a new deployment ...", bldId));
            }
            return this.verifyBuild(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()), this.getTimeout(listener, chatty, overrides), client, this.getBldCfg(overrides), bldId, this.getNamespace(overrides), chatty, listener, DISPLAY_NAME, checkDeps, false, overrides);
        }
        return false;
    }

    public static class BuildNameComparator
    implements Comparator<IBuild> {
        @Override
        public int compare(IBuild o1, IBuild o2) {
            String id2;
            String id1 = o1.getName();
            int at = StringUtils.indexOfDifference((String)id1, (String)(id2 = o2.getName()));
            if (at == -1) {
                return 0;
            }
            String rem0 = id1.substring(at);
            String rem1 = id2.substring(at);
            if (StringUtils.isBlank((String)rem0)) {
                return -1;
            }
            if (StringUtils.isBlank((String)rem1)) {
                return 1;
            }
            if (Integer.valueOf(rem0) < Integer.valueOf(rem1)) {
                return -1;
            }
            return 1;
        }
    }
}

