/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.dsl;

import com.openshift.jenkins.plugins.pipeline.Argument;
import com.openshift.jenkins.plugins.pipeline.ParamVerify;
import com.openshift.jenkins.plugins.pipeline.dsl.OpenShiftExecExecution;
import com.openshift.jenkins.plugins.pipeline.dsl.TimedOpenShiftBaseStep;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftExec;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPluginDescriptor;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class OpenShiftExec
extends TimedOpenShiftBaseStep
implements IOpenShiftExec {
    protected String pod;
    protected String container;
    protected String command;
    protected List<Argument> arguments = new ArrayList<Argument>();
    private final String LF = System.getProperty("line.separator");
    private StringBuffer stdOut = new StringBuffer();
    private StringBuffer stdErr = new StringBuffer();
    private StringBuffer errorMessage = new StringBuffer();
    private StringBuffer failureMessage = new StringBuffer();

    @DataBoundConstructor
    public OpenShiftExec(String pod) {
        this.pod = pod != null ? pod.trim() : null;
    }

    @DataBoundSetter
    public void setContainer(String container) {
        this.container = container != null ? container.trim() : null;
    }

    @DataBoundSetter
    public void setCommand(String command) {
        this.command = command != null ? command.trim() : null;
    }

    @DataBoundSetter
    public void setArguments(List<Argument> arguments) {
        this.arguments = arguments;
    }

    @Override
    public String getPod() {
        return this.pod;
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public List<Argument> getArguments() {
        return this.arguments;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    @Override
    public void onStdOut(String message) {
        this.stdOut.append(message.trim() + this.LF);
    }

    @Override
    public void onStdErr(String message) {
        this.stdErr.append(message.trim() + this.LF);
    }

    @Override
    public void onExecErr(String message) {
        this.errorMessage.append(message.trim() + this.LF);
    }

    @Override
    public void onFailure(IOException e) {
        this.failureMessage.append(e.getMessage().trim() + this.LF);
    }

    public OpenShiftExecExecution.ExecResult getExecResult() {
        return new StepExecOutput();
    }

    public class StepExecOutput
    implements OpenShiftExecExecution.ExecResult {
        @Override
        @Whitelisted
        public String getStdout() {
            return OpenShiftExec.this.stdOut.toString();
        }

        @Override
        @Whitelisted
        public String getStderr() {
            return OpenShiftExec.this.stdErr.toString();
        }

        @Override
        @Whitelisted
        public String getError() {
            return OpenShiftExec.this.errorMessage.toString();
        }

        @Override
        @Whitelisted
        public String getFailure() {
            return OpenShiftExec.this.failureMessage.toString();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl
    implements IOpenShiftPluginDescriptor {
        public DescriptorImpl() {
            super(OpenShiftExecExecution.class);
        }

        public String getFunctionName() {
            return "openshiftExec";
        }

        public String getDisplayName() {
            return "OpenShift Exec";
        }

        private Object requiredArgument(Map<String, Object> arguments, String arg) {
            Object o = arguments.get(arg);
            if (o == null) {
                throw new IllegalArgumentException("Missing required argument: " + arg);
            }
            return o;
        }

        private String argumentAsString(Map<String, Object> arguments, String arg, String def) {
            Object o = arguments.get(arg);
            if (o == null) {
                return def;
            }
            return o.toString();
        }

        private String argumentAsString(Map<String, Object> arguments, String arg) throws IllegalArgumentException {
            return this.requiredArgument(arguments, arg).toString();
        }

        public Step newInstance(Map<String, Object> arguments) throws Exception {
            OpenShiftExec step = new OpenShiftExec(this.argumentAsString(arguments, "pod"));
            step.setContainer(this.argumentAsString(arguments, "container", ""));
            Object commandObject = this.requiredArgument(arguments, "command");
            if (commandObject instanceof String) {
                step.setCommand(commandObject.toString());
            } else if (commandObject instanceof List) {
                List commandList = (List)commandObject;
                Iterator i = commandList.iterator();
                if (!i.hasNext()) {
                    throw new IllegalArgumentException("Command list cannot be empty");
                }
                step.setCommand(i.next().toString());
                ArrayList<Argument> commandArgs = new ArrayList<Argument>();
                while (i.hasNext()) {
                    commandArgs.add(new Argument(i.next().toString()));
                }
                step.setArguments(commandArgs);
            } else {
                throw new IllegalArgumentException("Unrecognized command syntax. It created type: " + commandObject.getClass().getName());
            }
            Object argumentsObject = arguments.get("arguments");
            if (argumentsObject != null) {
                if (argumentsObject instanceof List) {
                    ArrayList<Argument> commandArgs = new ArrayList<Argument>();
                    for (Object o : (List)argumentsObject) {
                        String arg;
                        if (o instanceof Map) {
                            Object aObject = ((Map)o).get("value");
                            if (aObject == null) {
                                throw new IllegalArgumentException("Expected value entry in arguments map: " + o.toString());
                            }
                            arg = aObject.toString().trim();
                        } else {
                            arg = o.toString().trim();
                        }
                        commandArgs.add(new Argument(arg));
                    }
                    step.setArguments(commandArgs);
                } else {
                    throw new IllegalArgumentException("Unrecognized arguments syntax. It created type: " + argumentsObject.getClass().getName());
                }
            }
            ParamVerify.updateTimedDSLBaseStep(arguments, step);
            return step;
        }
    }
}

