/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.dsl;

import com.openshift.jenkins.plugins.pipeline.NameValuePair;
import com.openshift.jenkins.plugins.pipeline.ParamVerify;
import com.openshift.jenkins.plugins.pipeline.dsl.OpenShiftBuilderExecution;
import com.openshift.jenkins.plugins.pipeline.dsl.TimedOpenShiftBaseStep;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftBuilder;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPluginDescriptor;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class OpenShiftBuilder
extends TimedOpenShiftBaseStep
implements IOpenShiftBuilder {
    protected final String bldCfg;
    protected String commitID;
    protected String buildName;
    protected String showBuildLogs;
    protected String checkForTriggeredDeployments;
    protected List<NameValuePair> envVars = new ArrayList<NameValuePair>();

    @DataBoundConstructor
    public OpenShiftBuilder(String bldCfg) {
        this.bldCfg = bldCfg;
    }

    @Override
    public String getCommitID() {
        return this.commitID;
    }

    @DataBoundSetter
    public void setCommitID(String commitID) {
        this.commitID = commitID != null ? commitID.trim() : null;
    }

    @Override
    public String getBuildName() {
        return this.buildName;
    }

    @DataBoundSetter
    public void setBuildName(String buildName) {
        this.buildName = buildName != null ? buildName.trim() : null;
    }

    @Override
    public String getShowBuildLogs() {
        return this.showBuildLogs;
    }

    @DataBoundSetter
    public void setShowBuildLogs(String showBuildLogs) {
        this.showBuildLogs = showBuildLogs != null ? showBuildLogs.trim() : null;
    }

    @Override
    public String getBldCfg() {
        return this.bldCfg;
    }

    @Override
    public List<NameValuePair> getEnv() {
        return this.envVars;
    }

    @DataBoundSetter
    public void setEnv(List<NameValuePair> v) {
        this.envVars = v;
    }

    @Override
    public String getCheckForTriggeredDeployments() {
        return this.checkForTriggeredDeployments;
    }

    @DataBoundSetter
    public void setCheckForTriggeredDeployments(String checkForTriggeredDeployments) {
        this.checkForTriggeredDeployments = checkForTriggeredDeployments != null ? checkForTriggeredDeployments.trim() : null;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl
    implements IOpenShiftPluginDescriptor {
        public DescriptorImpl() {
            super(OpenShiftBuilderExecution.class);
        }

        public String getFunctionName() {
            return "openshiftBuild";
        }

        public String getDisplayName() {
            return "Trigger OpenShift Build";
        }

        public Step newInstance(Map<String, Object> arguments) throws Exception {
            Object envObject;
            Object showBuildLogs;
            Object commitID;
            Object checkForTriggeredDeployments;
            Object buildName;
            if (!arguments.containsKey("buildConfig") && !arguments.containsKey("bldCfg")) {
                throw new IllegalArgumentException("need to specify buildConfig");
            }
            Object bldCfg = arguments.get("buildConfig");
            if (bldCfg == null || bldCfg.toString().trim().length() == 0) {
                bldCfg = arguments.get("bldCfg");
            }
            if (bldCfg == null || bldCfg.toString().trim().length() == 0) {
                throw new IllegalArgumentException("need to specify buildConfig");
            }
            OpenShiftBuilder step = new OpenShiftBuilder(bldCfg.toString());
            if (arguments.containsKey("buildName") && (buildName = arguments.get("buildName")) != null) {
                step.setBuildName(buildName.toString());
            }
            if (arguments.containsKey("checkForTriggeredDeployments") && (checkForTriggeredDeployments = arguments.get("checkForTriggeredDeployments")) != null) {
                step.setCheckForTriggeredDeployments(checkForTriggeredDeployments.toString());
            }
            if (arguments.containsKey("commitID") && (commitID = arguments.get("commitID")) != null) {
                step.setCommitID(commitID.toString());
            }
            if (arguments.containsKey("showBuildLogs") && (showBuildLogs = arguments.get("showBuildLogs")) != null) {
                step.setShowBuildLogs(showBuildLogs.toString());
            }
            if ((envObject = arguments.get("env")) != null) {
                try {
                    ArrayList<NameValuePair> envs = new ArrayList<NameValuePair>();
                    List l = (List)envObject;
                    for (Object o : l) {
                        Map m = (Map)o;
                        Object name = m.get("name");
                        Object value = m.get("value");
                        if (name == null || value == null) {
                            throw new IOException("Missing name or value in entry: " + o.toString());
                        }
                        envs.add(new NameValuePair(name.toString().trim(), value.toString().trim()));
                    }
                    step.setEnv(envs);
                }
                catch (Throwable t) {
                    throw new UnsupportedOperationException("Environment variables must be specified as follows: env: [ [ name : 'name1', value : 'value2' ], ... ]. Error: " + t.getMessage());
                }
            }
            ParamVerify.updateTimedDSLBaseStep(arguments, step);
            return step;
        }
    }
}

