/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPluginDescriptor;
import com.openshift.jenkins.plugins.pipeline.model.ITimedOpenShiftPlugin;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public abstract class TimedBuildStepDescriptor<T extends BuildStep & Describable<T>>
extends BuildStepDescriptor<T>
implements IOpenShiftPluginDescriptor {
    protected String wait;
    protected String waitUnit;

    TimedBuildStepDescriptor() {
        this.load();
    }

    public synchronized void load() {
        super.load();
        if (this.wait == null || this.wait.trim().isEmpty()) {
            this.wait = "" + this.getStaticDefaultWaitTime();
        }
        long w = Long.parseLong(this.wait);
        if (this.waitUnit == null || this.waitUnit.trim().isEmpty()) {
            if (w > 1000L && w % ITimedOpenShiftPlugin.TimeoutUnit.SECONDS.multiplier == 0L) {
                this.waitUnit = ITimedOpenShiftPlugin.TimeoutUnit.SECONDS.name;
                w /= ITimedOpenShiftPlugin.TimeoutUnit.SECONDS.multiplier;
            } else {
                this.waitUnit = ITimedOpenShiftPlugin.TimeoutUnit.MILLISECONDS.name;
            }
        }
        this.wait = "" + w;
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return true;
    }

    public synchronized boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.wait = formData.getString("wait");
        this.waitUnit = ITimedOpenShiftPlugin.TimeoutUnit.normalize(formData.getString("waitUnit"));
        if (this.wait == null || this.wait.isEmpty()) {
            this.wait = "" + this.getStaticDefaultWaitTime() / ITimedOpenShiftPlugin.TimeoutUnit.SECONDS.multiplier;
            this.waitUnit = ITimedOpenShiftPlugin.TimeoutUnit.SECONDS.name;
        }
        this.wait = this.wait.trim();
        this.save();
        return true;
    }

    public synchronized long getConfiguredDefaultWaitTime() {
        ITimedOpenShiftPlugin.TimeoutUnit unit = ITimedOpenShiftPlugin.TimeoutUnit.getByName(this.waitUnit);
        return unit.toMilliseconds("" + this.wait, this.getStaticDefaultWaitTime());
    }

    public synchronized String getWait() {
        return this.wait;
    }

    public synchronized String getWaitUnit() {
        return this.waitUnit;
    }

    protected abstract long getStaticDefaultWaitTime();
}

