/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.jenkins.plugins.pipeline.OpenShiftBaseStep;
import com.openshift.jenkins.plugins.pipeline.ParamVerify;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPluginDescriptor;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftServiceVerifier;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class OpenShiftServiceVerifier
extends OpenShiftBaseStep
implements IOpenShiftServiceVerifier {
    protected final String svcName;
    protected String retryCount;

    @DataBoundConstructor
    public OpenShiftServiceVerifier(String apiURL, String svcName, String namespace, String authToken, String verbose) {
        super(apiURL, namespace, authToken, verbose);
        this.svcName = svcName != null ? svcName.trim() : null;
    }

    @Override
    public String getSvcName() {
        return this.svcName;
    }

    @Override
    public String getRetryCount() {
        return this.retryCount;
    }

    @Override
    public String getRetryCount(Map<String, String> overrides) {
        String val = this.getOverride(this.getRetryCount(), overrides);
        if (val.length() > 0) {
            return val;
        }
        return Integer.toString(this.getDescriptor().getRetry());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder>
    implements IOpenShiftPluginDescriptor {
        private int retry = 100;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckSvcName(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckSvcName(value);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Verify OpenShift Service";
        }

        public int getRetry() {
            return this.retry;
        }

        public synchronized boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.retry = formData.getInt("retry");
            this.save();
            return super.configure(req, formData);
        }

        public synchronized int getConfiguredRetryCount() {
            return this.retry;
        }
    }
}

