/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.jenkins.plugins.pipeline.Auth;
import com.openshift.jenkins.plugins.pipeline.ImageStreamRevisionState;
import com.openshift.jenkins.plugins.pipeline.ParamVerify;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPlugin;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPluginDescriptor;
import com.openshift.restclient.IClient;
import com.openshift.restclient.NotFoundException;
import com.openshift.restclient.model.IImageStream;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class OpenShiftImageStreams
extends SCM
implements IOpenShiftPlugin {
    protected static final String DISPLAY_NAME = "OpenShift ImageStreams";
    protected final String imageStreamName;
    protected final String tag;
    protected final String apiURL;
    protected final String namespace;
    protected final String authToken;
    protected final String verbose;
    protected String lastCommitId = null;
    protected transient Auth auth;

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @DataBoundConstructor
    public OpenShiftImageStreams(String imageStreamName, String tag, String apiURL, String namespace, String authToken, String verbose) {
        this.imageStreamName = imageStreamName != null ? imageStreamName.trim() : null;
        this.tag = tag != null ? tag.trim() : null;
        this.apiURL = apiURL != null ? apiURL.trim() : null;
        this.namespace = namespace != null ? namespace.trim() : null;
        this.authToken = authToken != null ? authToken.trim() : null;
        this.verbose = verbose != null ? verbose.trim() : null;
    }

    @Override
    public String getApiURL() {
        return this.apiURL;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getAuthToken() {
        return this.authToken;
    }

    public String getImageStreamName() {
        return this.imageStreamName;
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public String getVerbose() {
        return this.verbose;
    }

    public String getImageStreamName(Map<String, String> overrides) {
        return this.getOverride(this.getImageStreamName(), overrides);
    }

    public String getTag(Map<String, String> overrides) {
        return this.getOverride(this.getTag(), overrides);
    }

    protected String getCommitId(TaskListener listener, Map<String, String> overrides) {
        String commitId;
        boolean chatty;
        block3: {
            chatty = Boolean.parseBoolean(this.verbose);
            this.setAuth(Auth.createInstance(null, this.getApiURL(overrides), overrides));
            IClient client = this.getClient(listener, DISPLAY_NAME, overrides);
            commitId = null;
            String imageStream = this.getImageStreamName(overrides);
            try {
                IImageStream isImpl = (IImageStream)client.get("ImageStream", imageStream, this.getNamespace(overrides));
                commitId = isImpl.getImageId(this.tag);
            }
            catch (NotFoundException e) {
                if (!chatty) break block3;
                listener.getLogger().println("\n\nImageStream " + imageStream + " not found");
            }
        }
        if (chatty) {
            listener.getLogger().println("\n\nOpenShiftImageStreams image ID used for Jenkins 'commitId' is " + commitId);
        }
        return commitId;
    }

    public void checkout(Run<?, ?> build, Launcher launcher, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState baseline) throws IOException, InterruptedException {
        boolean chatty = Boolean.parseBoolean(this.verbose);
        String bldName = null;
        if (build != null) {
            bldName = build.getDisplayName();
        }
        if (chatty) {
            listener.getLogger().println("\n\nOpenShiftImageStreams checkout called for " + bldName);
        }
        EnvVars env = build.getEnvironment(listener);
        this.lastCommitId = this.getCommitId(listener, (Map<String, String>)env);
        if (this.lastCommitId == null) {
            String imageStream = this.getImageStreamName((Map<String, String>)env);
            String tag = this.getTag((Map<String, String>)env);
            listener.getLogger().println(String.format("\n\nCannot find the last tagged image for ImageStream %s and tag %s", imageStream, tag));
            build.setResult(Result.FAILURE);
        }
    }

    public void postCheckout(@Nonnull Run<?, ?> build, @Nonnull Launcher launcher, @Nonnull FilePath workspace, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        if (build.getResult() == Result.FAILURE) {
            EnvVars env = build.getEnvironment(listener);
            String msg = String.format("\n\nCannot find the last tagged image for ImageStream %s and tag %s", this.getImageStreamName((Map<String, String>)env), this.getTag((Map<String, String>)env));
            throw new AbortException(msg);
        }
    }

    public ChangeLogParser createChangeLogParser() {
        return null;
    }

    public SCMRevisionState calcRevisionsFromBuild(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment(listener);
        listener.getLogger().println(String.format("\n\nThe \"%s\" SCM will return the last revision state stored in Jenkins for the image stream \"%s\" and tag \"%s\" from the project \"%s\".", DISPLAY_NAME, this.getImageStreamName((Map<String, String>)env), this.tag, this.getNamespace((Map)env)));
        String commitId = this.lastCommitId;
        ImageStreamRevisionState currIMSState = null;
        if (commitId != null) {
            currIMSState = new ImageStreamRevisionState(commitId);
            listener.getLogger().println(String.format("  Last revision:  [%s]", currIMSState.toString()));
        } else {
            currIMSState = new ImageStreamRevisionState("");
            listener.getLogger().println("  No revision state has been retrieved and stored yet.");
        }
        return currIMSState;
    }

    protected PollingResult compareRemoteRevisionInternal(EnvVars env, Launcher launcher, TaskListener listener, SCMRevisionState baseline) {
        boolean chatty;
        listener.getLogger().println(String.format("\n\nThe \"%s\" SCM is pulling the lastest revision state from OpenShift for the image stream \"%s\" and tag \"%s\" from the project \"%s\" and storing in Jenkins.", DISPLAY_NAME, this.getImageStreamName((Map<String, String>)env), this.tag, this.getNamespace((Map)env)));
        String commitId = this.getCommitId(listener, (Map<String, String>)env);
        ImageStreamRevisionState currIMSState = null;
        if (commitId != null) {
            currIMSState = new ImageStreamRevisionState(commitId);
        }
        if (chatty = Boolean.parseBoolean(this.verbose)) {
            listener.getLogger().println("\n\nOpenShiftImageStreams compareRemoteRevisionWith comparing baseline " + baseline + " with lastest " + currIMSState);
        }
        boolean changes = false;
        if (baseline != null && baseline instanceof ImageStreamRevisionState && currIMSState != null) {
            boolean bl = changes = !currIMSState.equals(baseline);
        }
        if (baseline == null && currIMSState != null) {
            changes = true;
        }
        if (changes) {
            this.lastCommitId = commitId;
            listener.getLogger().println("\n\n A revision change was found this polling cycle.");
        } else {
            listener.getLogger().println("\n\n No revision change found this polling cycle.");
        }
        return new PollingResult(baseline, (SCMRevisionState)currIMSState, changes ? PollingResult.Change.SIGNIFICANT : PollingResult.Change.NONE);
    }

    public PollingResult compareRemoteRevisionWith(@Nonnull Job<?, ?> project, @Nullable Launcher launcher, @Nullable FilePath workspace, @Nonnull TaskListener listener, @Nonnull SCMRevisionState baseline) throws IOException, InterruptedException {
        return this.compareRemoteRevisionInternal(project.getEnvironment(null, listener), launcher, listener, baseline);
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        return this.compareRemoteRevisionInternal(project.getEnvironment(null, listener), launcher, listener, baseline);
    }

    public SCMDescriptor<?> getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    @Override
    public String getBaseClassName() {
        return OpenShiftImageStreams.class.getName();
    }

    @Override
    public void setAuth(Auth auth) {
        this.auth = auth;
    }

    @Override
    public boolean coreLogic(Launcher launcher, TaskListener listener, Map<String, String> overrides) {
        return false;
    }

    @Override
    public Auth getAuth() {
        return this.auth;
    }

    @Extension
    public static class DescriptorImpl
    extends SCMDescriptor
    implements IOpenShiftPluginDescriptor {
        public DescriptorImpl() {
            super(OpenShiftImageStreams.class, null);
            this.load();
        }

        public FormValidation doCheckTag(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckTag(value);
        }

        public FormValidation doCheckImageStreamName(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckImageStreamName(value);
        }

        public String getDisplayName() {
            return OpenShiftImageStreams.DISPLAY_NAME;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return super.configure(req, json);
        }
    }
}

