/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.jenkins.plugins.pipeline.Argument;
import com.openshift.jenkins.plugins.pipeline.TimedBuildStepDescriptor;
import com.openshift.jenkins.plugins.pipeline.TimedOpenShiftBaseStep;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftApiObjHandler;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftExec;
import hudson.Extension;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class OpenShiftExec
extends TimedOpenShiftBaseStep
implements IOpenShiftExec,
IOpenShiftApiObjHandler {
    protected final String pod;
    protected final String container;
    protected final String command;
    protected final List<Argument> arguments;

    @Override
    public String getPod() {
        return this.pod;
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @DataBoundConstructor
    public OpenShiftExec(String apiURL, String namespace, String authToken, String verbose, String pod, String container, String command, List<Argument> arguments, String waitTime, String waitUnit) {
        super(apiURL, namespace, authToken, verbose, waitTime, waitUnit);
        this.pod = pod != null ? pod.trim() : null;
        this.container = container != null ? container.trim() : null;
        this.command = command != null ? command.trim() : null;
        this.arguments = arguments;
    }

    @Extension
    public static final class DescriptorImpl
    extends TimedBuildStepDescriptor<Builder> {
        public FormValidation doCheckPod(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckCommand(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.validateRequired((String)value);
        }

        public String getDisplayName() {
            return "OpenShift Exec";
        }

        @Override
        protected long getStaticDefaultWaitTime() {
            return 180000L;
        }
    }
}

