/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.jenkins.plugins.pipeline.OpenShiftBasePostAction;
import com.openshift.jenkins.plugins.pipeline.ParamVerify;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPluginDescriptor;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class OpenShiftDeployCanceller
extends OpenShiftBasePostAction {
    protected static final String DISPLAY_NAME = "Cancel OpenShift Deployment";
    protected final String depCfg;

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @DataBoundConstructor
    public OpenShiftDeployCanceller(String apiURL, String depCfg, String namespace, String authToken, String verbose) {
        super(apiURL, namespace, authToken, verbose);
        this.depCfg = depCfg != null ? depCfg.trim() : null;
    }

    public String getDepCfg() {
        return this.depCfg;
    }

    public String getDepCfg(Map<String, String> overrides) {
        return this.getOverride(this.getDepCfg(), overrides);
    }

    @Override
    public boolean coreLogic(Launcher launcher, TaskListener listener, Map<String, String> overrides) {
        listener.getLogger().println(String.format("\n\nStarting \"%s\" with deployment config \"%s\" from the project \"%s\".", DISPLAY_NAME, this.getDepCfg(overrides), this.getNamespace(overrides)));
        IClient client = this.getClient(listener, DISPLAY_NAME, overrides);
        if (client != null) {
            IDeploymentConfig dc = (IDeploymentConfig)client.get("DeploymentConfig", this.getDepCfg(overrides), this.getNamespace(overrides));
            if (dc == null) {
                listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; the deployment config \"%s\" could not be read.", DISPLAY_NAME, this.getDepCfg(overrides)));
                return false;
            }
            boolean chatty = Boolean.parseBoolean(this.getVerbose(overrides));
            IReplicationController rc = this.getLatestReplicationController(dc, this.getNamespace(overrides), client, (TaskListener)(chatty ? listener : null));
            if (rc != null) {
                String state = this.getReplicationControllerState(rc);
                if (state.equalsIgnoreCase("Failed") || state.equalsIgnoreCase("Complete") || state.equalsIgnoreCase("Cancelled")) {
                    listener.getLogger().println(String.format("\n\nExiting \"Cancel OpenShift Deployment\" successfully; the deployment \"%s\" is not in-progress; its status is:  [%s].", rc.getName(), state));
                    return true;
                }
                rc.setAnnotation("openshift.io/deployment.cancelled", "true");
                rc.setAnnotation("openshift.io/deployment.status-reason", "The deployment was cancelled by the user");
                client.update((IResource)rc);
                listener.getLogger().println(String.format("\n\nExiting \"Cancel OpenShift Deployment\" successfully; the deployment \"%s\" has been cancelled.", rc.getName()));
                return true;
            }
            if (dc.getLatestVersionNumber() > 0) {
                listener.getLogger().println(String.format("\n\nExiting \"Cancel OpenShift Deployment\" unsuccessfully; the latest deployment for \"%s\" could not be retrieved.", this.getDepCfg(overrides)));
                return false;
            }
            listener.getLogger().println(String.format("\n\nExiting \"Cancel OpenShift Deployment\" successfully; there no deployments yet for \"%s\".", this.getDepCfg(overrides)));
            return true;
        }
        return false;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher>
    implements IOpenShiftPluginDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckDepCfg(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckDepCfg(value);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return OpenShiftDeployCanceller.DISPLAY_NAME;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

