/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.jenkins.plugins.pipeline.OpenShiftBaseStep;
import com.openshift.jenkins.plugins.pipeline.ParamVerify;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftDeleterLabels;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPluginDescriptor;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class OpenShiftDeleterLabels
extends OpenShiftBaseStep
implements IOpenShiftDeleterLabels {
    protected final String types;
    protected final String keys;
    protected final String values;

    @DataBoundConstructor
    public OpenShiftDeleterLabels(String apiURL, String namespace, String authToken, String verbose, String types, String keys, String values) {
        super(apiURL, namespace, authToken, verbose);
        this.types = types != null ? types.trim() : null;
        this.keys = keys != null ? keys.trim() : null;
        this.values = values != null ? values.trim() : null;
    }

    @Override
    public String getTypes() {
        return this.types;
    }

    @Override
    public String getKeys() {
        return this.keys;
    }

    @Override
    public String getValues() {
        return this.values;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder>
    implements IOpenShiftPluginDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckType(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckType(value);
        }

        public FormValidation doCheckKey(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckKey(value);
        }

        public ListBoxModel doFillInputTypeItems(@AncestorInPath Item item, @QueryParameter String key, @QueryParameter String type) {
            ListBoxModel ret = new ListBoxModel();
            ret.add("Json contents", "json");
            ret.add("API Object type : API Object key", "kv");
            ret.add("Label", "label");
            return ret;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Delete OpenShift Resource(s) using Labels";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

