/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.jenkins.plugins.pipeline.NameValuePair;
import com.openshift.jenkins.plugins.pipeline.ParamVerify;
import com.openshift.jenkins.plugins.pipeline.TimedBuildStepDescriptor;
import com.openshift.jenkins.plugins.pipeline.TimedOpenShiftBaseStep;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftBuilder;
import com.openshift.jenkins.plugins.pipeline.model.ITimedOpenShiftPlugin;
import hudson.Extension;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class OpenShiftBuilder
extends TimedOpenShiftBaseStep
implements IOpenShiftBuilder,
ITimedOpenShiftPlugin {
    protected final String bldCfg;
    protected final String commitID;
    protected final String buildName;
    protected final String showBuildLogs;
    protected final String checkForTriggeredDeployments;
    protected final List<NameValuePair> envVars;

    @DataBoundConstructor
    public OpenShiftBuilder(String apiURL, String bldCfg, String namespace, List<NameValuePair> env, String authToken, String verbose, String commitID, String buildName, String showBuildLogs, String checkForTriggeredDeployments, String waitTime, String waitUnit) {
        super(apiURL, namespace, authToken, verbose, waitTime, waitUnit);
        this.bldCfg = bldCfg != null ? bldCfg.trim() : null;
        this.envVars = env;
        this.commitID = commitID != null ? commitID.trim() : null;
        this.buildName = buildName != null ? buildName.trim() : null;
        this.showBuildLogs = showBuildLogs != null ? showBuildLogs.trim() : null;
        this.checkForTriggeredDeployments = checkForTriggeredDeployments != null ? checkForTriggeredDeployments.trim() : null;
    }

    @Override
    public String getCommitID() {
        return this.commitID;
    }

    @Override
    public String getBuildName() {
        return this.buildName;
    }

    @Override
    public String getShowBuildLogs() {
        return this.showBuildLogs;
    }

    @Override
    public String getBldCfg() {
        return this.bldCfg;
    }

    @Override
    public List<NameValuePair> getEnv() {
        return this.envVars;
    }

    @Override
    public String getCheckForTriggeredDeployments() {
        return this.checkForTriggeredDeployments;
    }

    @Extension
    public static final class DescriptorImpl
    extends TimedBuildStepDescriptor<Builder> {
        public FormValidation doCheckBldCfg(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckBldCfg(value);
        }

        public String getDisplayName() {
            return "Trigger OpenShift Build";
        }

        @Override
        protected long getStaticDefaultWaitTime() {
            return 900000L;
        }
    }
}

