/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.jenkins.plugins.pipeline.ParamVerify;
import com.openshift.jenkins.plugins.pipeline.TimedBuildStepDescriptor;
import com.openshift.jenkins.plugins.pipeline.TimedOpenShiftBaseStep;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftBuildVerifier;
import hudson.Extension;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class OpenShiftBuildVerifier
extends TimedOpenShiftBaseStep
implements IOpenShiftBuildVerifier {
    protected final String bldCfg;
    protected final String checkForTriggeredDeployments;

    @DataBoundConstructor
    public OpenShiftBuildVerifier(String apiURL, String bldCfg, String namespace, String authToken, String verbose, String checkForTriggeredDeployments, String waitTime, String waitUnit) {
        super(apiURL, namespace, authToken, verbose, waitTime, waitUnit);
        this.bldCfg = bldCfg != null ? bldCfg.trim() : null;
        this.checkForTriggeredDeployments = checkForTriggeredDeployments != null ? checkForTriggeredDeployments.trim() : null;
    }

    @Override
    public String getBldCfg() {
        return this.bldCfg;
    }

    @Override
    public String getCheckForTriggeredDeployments() {
        return this.checkForTriggeredDeployments;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends TimedBuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        @Override
        protected long getStaticDefaultWaitTime() {
            return 60000L;
        }

        public FormValidation doCheckBldCfg(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckBldCfg(value);
        }

        public String getDisplayName() {
            return "Verify OpenShift Build";
        }
    }
}

