/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.jenkins.plugins.pipeline.OpenShiftBasePostAction;
import com.openshift.jenkins.plugins.pipeline.ParamVerify;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPluginDescriptor;
import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IBuildCancelable;
import com.openshift.restclient.model.IBuild;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class OpenShiftBuildCanceller
extends OpenShiftBasePostAction {
    protected static final String DISPLAY_NAME = "Cancel OpenShift Builds";
    protected final String bldCfg;

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @DataBoundConstructor
    public OpenShiftBuildCanceller(String apiURL, String namespace, String authToken, String verbose, String bldCfg) {
        super(apiURL, namespace, authToken, verbose);
        this.bldCfg = bldCfg != null ? bldCfg.trim() : null;
    }

    public String getBldCfg() {
        return this.bldCfg;
    }

    public String getBldCfg(Map<String, String> overrides) {
        return this.getOverride(this.getBldCfg(), overrides);
    }

    @Override
    public boolean coreLogic(Launcher launcher, TaskListener listener, Map<String, String> overrides) {
        boolean chatty = Boolean.parseBoolean(this.verbose);
        listener.getLogger().println(String.format("\n\nStarting the \"%s\" step with build config \"%s\" from the project \"%s\".", DISPLAY_NAME, this.getBldCfg(overrides), this.getNamespace(overrides)));
        IClient client = this.getClient(listener, DISPLAY_NAME, overrides);
        if (client != null) {
            List list = client.list("Build", this.getNamespace(overrides));
            int count = 0;
            for (IBuild bld : list) {
                String phaseStr = bld.getStatus();
                String buildName = bld.getName();
                if (!buildName.startsWith(this.getBldCfg(overrides)) || this.isBuildFinished(phaseStr)) continue;
                if (chatty) {
                    listener.getLogger().println("\nOpenShiftBuildCanceller found active build " + buildName);
                }
                bld = (IBuild)client.get("Build", buildName, this.getNamespace(overrides));
                bld.accept((CapabilityVisitor)new CapabilityVisitor<IBuildCancelable, IBuild>(){

                    public IBuild visit(IBuildCancelable cancelable) {
                        return cancelable.cancel();
                    }
                }, null);
                listener.getLogger().println(String.format("  Cancelled build \"%s\".", buildName));
                ++count;
            }
            listener.getLogger().println(String.format("\n\nExiting \"%s\" successfully with %d builds cancelled.", DISPLAY_NAME, count));
            return true;
        }
        return false;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher>
    implements IOpenShiftPluginDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckBldCfg(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckBldCfg(value);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return OpenShiftBuildCanceller.DISPLAY_NAME;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

