/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils.server;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class AbstractServer {
    public static final Option HELP_OPTION = new Option("h", "help", false, "print this message");
    public static final Option TCP_PORT_OPTION = new Option("p", "port", true, "TCP port");
    public static final Option HOST_OPTION = new Option("n", "hostname", true, "Listening hostname");
    public static final Option DATADIR_OPTION = new Option("d", "datadir", true, "Data directory");
    public final String defaultHostname;
    public final int defaultTcpPort;
    public final String mainJarPath;
    public final String default_datadir_name;

    protected AbstractServer(String defaultHostname, int defaultTcpPort, String mainJarPath, String default_datadir_name) {
        this.defaultHostname = defaultHostname;
        this.defaultTcpPort = defaultTcpPort;
        this.mainJarPath = mainJarPath;
        this.default_datadir_name = default_datadir_name;
    }

    public void defineOptions(Options options) {
        options.addOption(HELP_OPTION);
        options.addOption(TCP_PORT_OPTION);
        options.addOption(HOST_OPTION);
        options.addOption(DATADIR_OPTION);
    }

    public abstract void beforeStart(CommandLine var1, File var2) throws IOException, ParseException;

    public abstract void start(int var1, String var2) throws IOException, ParseException, ServletException;

    public final void start(String[] args) throws IOException, ParseException, ServletException {
        Logger.getLogger("").setLevel(Level.WARNING);
        Options options = new Options();
        this.defineOptions(options);
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption(HELP_OPTION.getOpt())) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar " + this.mainJarPath, options);
            return;
        }
        File dataDir = null;
        if (this.default_datadir_name != null) {
            dataDir = new File(System.getProperty("user.home"), this.default_datadir_name);
            if (cmd.hasOption(DATADIR_OPTION.getOpt())) {
                dataDir = new File(cmd.getOptionValue(DATADIR_OPTION.getOpt()));
            }
            if (!dataDir.exists()) {
                throw new IOException("The data directory does not exists: " + dataDir);
            }
            if (!dataDir.isDirectory()) {
                throw new IOException("The data directory path is not a directory: " + dataDir);
            }
        }
        this.beforeStart(cmd, dataDir);
        int port = cmd.hasOption(TCP_PORT_OPTION.getOpt()) ? Integer.parseInt(cmd.getOptionValue(TCP_PORT_OPTION.getOpt())) : this.defaultTcpPort;
        String hostname = cmd.hasOption(HOST_OPTION.getOpt()) ? cmd.getOptionValue(HOST_OPTION.getOpt()) : this.defaultHostname;
        this.start(port, hostname);
    }
}

