/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ServerResource {
    public String url;
    public Integer version;
    public String login;
    public String api_key;
    public String name;
    public int time_out;

    @XmlTransient
    @JsonIgnore
    public int getVersionOfDefault() {
        return this.version == null ? 1 : this.version;
    }

    @XmlTransient
    @JsonIgnore
    public static boolean sameResource(ServerResource serverResource1, ServerResource serverResource2) {
        if (serverResource1 == null || serverResource2 == null) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)serverResource1.url, (CharSequence)serverResource2.url)) {
            return false;
        }
        return StringUtils.equals((CharSequence)serverResource1.name, (CharSequence)serverResource2.name);
    }
}

