/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.opensearchserver.utils.json.JsonMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class JsonApplicationException
extends WebApplicationException {
    private static final long serialVersionUID = -4335415042425300057L;

    public JsonApplicationException(Response.Status status, String message) {
        super(JsonApplicationException.toResponse(status, message));
    }

    public JsonApplicationException(Exception e) {
        super(JsonApplicationException.toResponse(e));
    }

    public static Response toResponse(Response.Status status, JsonException jsonException) {
        try {
            String jsonMessage = JsonMapper.MAPPER.writeValueAsString((Object)jsonException);
            return Response.status((Response.Status)status).type("application/json").entity((Object)jsonMessage).build();
        }
        catch (JsonProcessingException e) {
            return Response.status((Response.Status)status).type("text/plain").entity((Object)jsonException.message).build();
        }
    }

    public static Response toResponse(Response.Status status, String message) {
        return JsonApplicationException.toResponse(status, new JsonException(status, message));
    }

    public static Response toResponse(Exception e) {
        if (e instanceof JsonApplicationException) {
            return ((JsonApplicationException)((Object)e)).getResponse();
        }
        return JsonApplicationException.toResponse(Response.Status.INTERNAL_SERVER_ERROR, new JsonException(Response.Status.INTERNAL_SERVER_ERROR, e));
    }

    public static Throwable getCause(Throwable throwable) {
        for (Throwable next = throwable; next != null; next = next.getCause()) {
            throwable = next;
        }
        return throwable;
    }

    public static List<String> getStackTraces(Throwable throwable) {
        StackTraceElement[] stElements = throwable.getStackTrace();
        if (stElements == null) {
            return null;
        }
        ArrayList<String> stList = new ArrayList<String>(stElements.length);
        for (StackTraceElement stElement : stElements) {
            stList.add(stElement.toString());
        }
        return stList;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class JsonException {
        public final String error;
        public final String reason_phrase;
        public final Integer status_code;
        public final String message;
        public final String exception;
        public final List<String> stackTraces;

        public JsonException(Response.Status status, String message) {
            this.error = status.name();
            this.reason_phrase = status.getReasonPhrase();
            this.status_code = status.getStatusCode();
            this.message = message;
            this.exception = null;
            this.stackTraces = null;
        }

        public JsonException(Response.Status status, Exception e) {
            this.error = status.name();
            this.reason_phrase = status.getReasonPhrase();
            this.status_code = status.getStatusCode();
            Throwable cause = JsonApplicationException.getCause(e);
            this.message = cause.getMessage();
            this.exception = cause.getClass().getName();
            this.stackTraces = JsonApplicationException.getStackTraces(cause);
        }
    }
}

