/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils.cassandra;

import com.datastax.driver.core.Cluster;
import com.opensearchserver.utils.LockUtils;
import com.opensearchserver.utils.cassandra.CassandraSession;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class CassandraCluster
implements Closeable {
    private final LockUtils.ReadWriteLock rwl = new LockUtils.ReadWriteLock();
    private Cluster cluster = null;
    private final String login;
    private final String password;
    private final List<String> hosts;
    private CassandraSession rootSession;
    private final LinkedHashMap<String, CassandraSession> sessions;

    public CassandraCluster(String login, String password, List<String> hosts) {
        this.login = login;
        this.password = password == null ? login : password;
        this.hosts = hosts;
        this.sessions = new LinkedHashMap();
    }

    public void finalize() {
        this.closeNoLock();
    }

    private void closeNoLock() {
        if (this.cluster != null) {
            IOUtils.closeQuietly((Closeable)this.cluster);
            this.cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.rwl.w.lock();
        try {
            this.rootSession = null;
            this.sessions.clear();
            this.closeNoLock();
        }
        finally {
            this.rwl.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCluster() {
        this.rwl.r.lock();
        try {
            if (this.cluster != null && !this.cluster.isClosed()) {
                return;
            }
        }
        finally {
            this.rwl.r.unlock();
        }
        this.rwl.w.lock();
        try {
            if (this.cluster != null && !this.cluster.isClosed()) {
                return;
            }
            Cluster.Builder builder = Cluster.builder();
            if (this.hosts != null) {
                for (String host : this.hosts) {
                    builder.addContactPoint(host);
                }
            }
            builder.withCredentials(this.login, this.password);
            this.cluster = builder.build();
            this.rootSession = null;
            this.sessions.clear();
        }
        finally {
            this.rwl.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CassandraSession getSession() {
        this.checkCluster();
        this.rwl.r.lock();
        try {
            if (this.rootSession != null) {
                CassandraSession cassandraSession = this.rootSession;
                return cassandraSession;
            }
        }
        finally {
            this.rwl.r.unlock();
        }
        this.rwl.w.lock();
        try {
            if (this.rootSession != null) {
                CassandraSession cassandraSession = this.rootSession;
                return cassandraSession;
            }
            CassandraSession cassandraSession = this.rootSession = new CassandraSession(this.cluster);
            return cassandraSession;
        }
        finally {
            this.rwl.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CassandraSession getSession(String keySpace) {
        CassandraSession session;
        if (keySpace == null) {
            return this.getSession();
        }
        this.checkCluster();
        keySpace = keySpace.intern();
        this.rwl.r.lock();
        try {
            session = this.sessions.get(keySpace);
            if (session != null) {
                CassandraSession cassandraSession = session;
                return cassandraSession;
            }
        }
        finally {
            this.rwl.r.unlock();
        }
        this.rwl.w.lock();
        try {
            session = this.sessions.get(keySpace);
            if (session != null) {
                CassandraSession cassandraSession = session;
                return cassandraSession;
            }
            session = new CassandraSession(this.cluster, keySpace);
            this.sessions.put(keySpace, session);
            CassandraSession cassandraSession = session;
            return cassandraSession;
        }
        finally {
            this.rwl.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireUnusedSince(int minutes) {
        this.rwl.r.lock();
        try {
            long time = System.currentTimeMillis() - (long)(minutes * 60 * 1000);
            for (CassandraSession session : this.sessions.values()) {
                if (session.getLastUse() >= time) continue;
                IOUtils.closeQuietly((Closeable)session);
            }
        }
        finally {
            this.rwl.r.unlock();
        }
        this.rwl.w.lock();
        try {
            ArrayList<String> keys = new ArrayList<String>();
            for (Map.Entry<String, CassandraSession> entry : this.sessions.entrySet()) {
                if (!entry.getValue().isClosed()) continue;
                keys.add(entry.getKey());
            }
            for (String key : keys) {
                this.sessions.remove(key);
            }
        }
        finally {
            this.rwl.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionCount() {
        this.rwl.r.lock();
        try {
            int n = this.sessions.size();
            return n;
        }
        finally {
            this.rwl.r.unlock();
        }
    }
}

