/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils.cache;

import com.opensearchserver.utils.cache.AbstractLRUCache;
import com.opensearchserver.utils.cache.AbstractLRUCacheItem;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class LRUCacheSize<K extends AbstractLRUCacheItem<K>>
extends AbstractLRUCache<K> {
    private int maxSize;

    public LRUCacheSize(int maxSize) {
        this.maxSize = maxSize;
        this.setMaxSize_noLock(maxSize);
    }

    private void setMaxSize_noLock(int newMaxSize) {
        if (newMaxSize == this.maxSize) {
            return;
        }
        if (newMaxSize == 0) {
            this.clear_nolock();
            this.cacheMap = null;
            this.evictionQueue = null;
        } else {
            if (newMaxSize < this.maxSize) {
                this.cacheMap = null;
                this.evictionQueue = null;
            }
            if (this.cacheMap == null) {
                this.cacheMap = new TreeMap();
            }
            if (this.evictionQueue == null) {
                this.evictionQueue = new EvictionQueue();
            }
        }
        this.maxSize = newMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int newMaxSize) {
        this.rwl.w.lock();
        try {
            this.setMaxSize_noLock(newMaxSize);
        }
        finally {
            this.rwl.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getMaxSize() {
        this.rwl.r.lock();
        try {
            int n = this.maxSize;
            return n;
        }
        finally {
            this.rwl.r.unlock();
        }
    }

    private class EvictionQueue
    extends LinkedHashMap<K, K> {
        private static final long serialVersionUID = 2876891913920705107L;

        private EvictionQueue() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, K> eldest) {
            if (this.size() <= LRUCacheSize.this.maxSize) {
                return false;
            }
            LRUCacheSize.this.cacheMap.remove(eldest.getKey());
            LRUCacheSize.this.evictions.incrementAndGet();
            return true;
        }
    }
}

