/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils.cache;

import com.opensearchserver.utils.LockUtils;
import com.opensearchserver.utils.cache.AbstractLRUCacheItem;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractLRUCache<K extends AbstractLRUCacheItem<K>> {
    protected final LockUtils.ReadWriteLock rwl = new LockUtils.ReadWriteLock();
    protected TreeMap<K, K> cacheMap = null;
    protected LinkedHashMap<K, K> evictionQueue = null;
    protected AtomicLong evictions = new AtomicLong(0L);
    private AtomicLong lookups = new AtomicLong(0L);
    private AtomicLong hits;
    private AtomicLong inserts = new AtomicLong(0L);

    protected AbstractLRUCache() {
        this.hits = new AtomicLong(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final K getAndPromote(K newItem) {
        this.rwl.w.lock();
        try {
            if (this.cacheMap == null) {
                K k = newItem;
                return k;
            }
            this.lookups.incrementAndGet();
            AbstractLRUCacheItem prevItem = (AbstractLRUCacheItem)this.cacheMap.get(newItem);
            if (prevItem != null) {
                this.evictionQueue.remove(prevItem);
                this.evictionQueue.put(prevItem, prevItem);
                this.hits.incrementAndGet();
                AbstractLRUCacheItem abstractLRUCacheItem = prevItem;
                return (K)abstractLRUCacheItem;
            }
            this.evictionQueue.put(newItem, newItem);
            this.cacheMap.put(newItem, newItem);
            this.inserts.incrementAndGet();
            K k = newItem;
            return k;
        }
        finally {
            this.rwl.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(K item) {
        this.rwl.w.lock();
        try {
            if (this.cacheMap == null) {
                return;
            }
            this.evictionQueue.put(item, item);
            this.cacheMap.put(item, item);
            this.inserts.incrementAndGet();
        }
        finally {
            this.rwl.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(K key) {
        this.rwl.w.lock();
        try {
            if (this.cacheMap == null) {
                boolean bl = false;
                return bl;
            }
            AbstractLRUCacheItem item1 = (AbstractLRUCacheItem)this.cacheMap.remove(key);
            AbstractLRUCacheItem item2 = (AbstractLRUCacheItem)this.evictionQueue.remove(key);
            if (item1 == null && item2 == null) {
                boolean bl = false;
                return bl;
            }
            this.evictions.incrementAndGet();
            boolean bl = true;
            return bl;
        }
        finally {
            this.rwl.w.unlock();
        }
    }

    public K getAndJoin(K item) throws Exception {
        item = this.getAndPromote(item);
        ((AbstractLRUCacheItem)item).join();
        return item;
    }

    protected final void clear_nolock() {
        if (this.cacheMap != null) {
            this.cacheMap.clear();
        }
        if (this.evictionQueue != null) {
            this.evictionQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        this.rwl.w.lock();
        try {
            this.clear_nolock();
        }
        finally {
            this.rwl.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSize() {
        this.rwl.r.lock();
        try {
            int n = this.cacheMap == null ? 0 : this.cacheMap.size();
            return n;
        }
        finally {
            this.rwl.r.unlock();
        }
    }

    public final long getEvictions() {
        return this.evictions.get();
    }

    public final long getLookups() {
        return this.lookups.get();
    }

    public final long getHits() {
        return this.hits.get();
    }

    public long getInserts() {
        return this.inserts.get();
    }

    public float getHitRatio() {
        float h = this.hits.get();
        float l = this.lookups.get();
        if (h == 0.0f || l == 0.0f) {
            return 0.0f;
        }
        return h / l;
    }
}

