/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils;

import com.opensearchserver.utils.ExceptionUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import javax.naming.NamingException;

public class ThreadUtils {
    public static Thread[] getThreadArray(ThreadGroup group) {
        int l;
        Thread[] threads = new Thread[group.activeCount()];
        while ((l = group.enumerate(threads)) != threads.length) {
            threads = new Thread[l];
        }
        return threads;
    }

    public static List<ThreadInfo> getInfos(String classNamePrefix, ThreadGroup ... groups) throws NamingException {
        if (groups == null) {
            return null;
        }
        int count = 0;
        ArrayList<Thread[]> threadsArrayList = new ArrayList<Thread[]>(groups.length);
        for (ThreadGroup group : groups) {
            Thread[] threadArray = ThreadUtils.getThreadArray(group);
            threadsArrayList.add(threadArray);
            count += threadArray.length;
        }
        ArrayList<ThreadInfo> threadList = new ArrayList<ThreadInfo>(count);
        Iterator i$ = threadsArrayList.iterator();
        while (i$.hasNext()) {
            Thread[] threadArray;
            for (Thread thread : threadArray = (Thread[])i$.next()) {
                threadList.add(new ThreadInfo(thread, classNamePrefix));
            }
        }
        return threadList;
    }

    public static final void sleepMs(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean waitUntil(long secTimeOut, WaitInterface waiter) {
        long finalTime = System.currentTimeMillis() + secTimeOut * 1000L;
        while (!waiter.done()) {
            if (waiter.abort()) {
                return false;
            }
            if (secTimeOut != 0L && System.currentTimeMillis() > finalTime) {
                return false;
            }
            ThreadUtils.sleepMs(200L);
        }
        return true;
    }

    public static void join(List<? extends ExceptionCatchThread> exceptionThreads) throws Exception {
        if (exceptionThreads == null) {
            return;
        }
        Exception exception = null;
        for (ExceptionCatchThread exceptionCatchThread : exceptionThreads) {
            try {
                exceptionCatchThread.join();
                if (exception != null || exceptionCatchThread.exception == null) continue;
                exception = exceptionCatchThread.exception;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static abstract class ExceptionCatchThread
    extends Thread {
        protected Exception exception;

        public ExceptionCatchThread() {
            this.exception = null;
        }

        public ExceptionCatchThread(ThreadGroup threadGroup, String threadName) {
            super(threadGroup, threadName);
        }

        public abstract void runner() throws Exception;

        @Override
        public void run() {
            try {
                this.runner();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }

    public static interface WaitInterface {
        public boolean done();

        public boolean abort();
    }

    public static class ThreadInfo {
        private final String name;
        private final String location;
        private final Thread.State state;
        private final String fullStackTrace;

        public ThreadInfo(Thread thread, String prefix) {
            this.name = thread.getName();
            StackTraceElement[] elements = thread.getStackTrace();
            String l = ExceptionUtils.getLocation(elements, prefix);
            if (l == null) {
                l = ExceptionUtils.getFirstLocation(elements);
            }
            this.fullStackTrace = ExceptionUtils.getFullStackTrace(elements);
            this.location = l;
            this.state = thread.getState();
        }

        public String getName() {
            return this.name;
        }

        public String getLocation() {
            return this.location;
        }

        public Thread.State getState() {
            return this.state;
        }

        public String getFullStackTrace() {
            return this.fullStackTrace;
        }
    }

    public static class ThreadGroupFactory
    implements ThreadFactory {
        private final ThreadGroup group;

        public ThreadGroupFactory(ThreadGroup group) {
            this.group = group;
        }

        @Override
        public Thread newThread(Runnable target) {
            return new Thread(this.group, target);
        }
    }
}

