/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.client.v1;

import com.opensearchserver.client.JsonClient1;
import com.opensearchserver.client.common.AbstractApi;
import com.opensearchserver.client.common.JsonClientAbstract;
import com.opensearchserver.client.common.update.DocumentUpdate;
import com.opensearchserver.utils.HttpUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;

public class UpdateApi1
extends AbstractApi<JsonClientAbstract> {
    public UpdateApi1(JsonClient1 client) {
        super(client);
    }

    public void deleteDocumentsByFieldValue(String indexName, String fieldName, List<String> values) throws IOException, URISyntaxException {
        StringBuilder deleteValues = new StringBuilder();
        for (String value : values) {
            deleteValues.append('/');
            deleteValues.append(value);
        }
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/document/" + fieldName + deleteValues.toString());
        Request request = Request.Delete((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, null, null);
        HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200});
    }

    public void updateDocuments(String indexName, List<DocumentUpdate> documents) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/document");
        Request request = Request.Put((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, documents, null);
        HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200});
    }
}

