/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.client.v1;

import com.opensearchserver.client.JsonClient1;
import com.opensearchserver.client.common.AbstractApi;
import com.opensearchserver.client.common.JsonClientAbstract;
import com.opensearchserver.client.common.index.TemplateEnum;
import com.opensearchserver.utils.HttpUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;

public class IndexApi1
extends AbstractApi<JsonClientAbstract> {
    public IndexApi1(JsonClient1 client) {
        super(client);
    }

    public void createIndex(String indexName, TemplateEnum template) throws IOException, URISyntaxException {
        if (indexName == null || indexName.isEmpty()) {
            throw new IllegalArgumentException("The index name is missing.");
        }
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/template/", template.name());
        Request request = Request.Post((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, null, null);
        HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200});
    }

    public boolean indexExists(String indexName) throws URISyntaxException, IOException {
        if (indexName == null || indexName.isEmpty()) {
            throw new IllegalArgumentException("The index name is missing.");
        }
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName);
        Request request = Request.Get((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, null, null);
        switch (HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200, 404})) {
            case 200: {
                return true;
            }
            case 404: {
                return false;
            }
        }
        return false;
    }

    public void deleteIndex(String indexName) throws IOException, URISyntaxException {
        if (indexName == null || indexName.isEmpty()) {
            throw new IllegalArgumentException("The index name is missing.");
        }
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName);
        Request request = Request.Delete((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, null, null);
        HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200});
    }
}

