/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.client.v1;

import com.opensearchserver.client.JsonClient1;
import com.opensearchserver.client.common.AbstractApi;
import com.opensearchserver.client.common.JsonClientAbstract;
import com.opensearchserver.client.v1.field.ResultField;
import com.opensearchserver.client.v1.field.ResultFieldList;
import com.opensearchserver.client.v1.field.SchemaField;
import com.opensearchserver.utils.HttpUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;

public class FieldApi1
extends AbstractApi<JsonClientAbstract> {
    public FieldApi1(JsonClient1 client) {
        super(client);
    }

    public ResultField getField(String indexName, String fieldName) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/field/", fieldName);
        Request request = Request.Get((URI)uriBuilder.build());
        return this.client.execute(request, null, null, ResultField.class, 200, 404);
    }

    public ResultFieldList getFields(String indexName) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/field");
        Request request = Request.Get((URI)uriBuilder.build());
        return this.client.execute(request, null, null, ResultFieldList.class, 200);
    }

    public void setField(String indexName, SchemaField field) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/field/" + field.name);
        Request request = Request.Put((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, field, null);
        HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200});
    }

    public void setFields(String indexName, List<SchemaField> fields) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/field");
        Request request = Request.Put((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, fields, null);
        HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200});
    }

    public void deleteField(String indexName, String fieldName) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/field/", fieldName);
        Request request = Request.Delete((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, null, null);
        HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200, 404});
    }

    public void setDefaultUniqueField(String indexName, String defaultField, String uniqueField) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/field").addParameter("default", defaultField).addParameter("unique", uniqueField);
        Request request = Request.Post((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, null, null);
        HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200});
    }
}

