/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.client.v1;

import com.opensearchserver.client.JsonClient1;
import com.opensearchserver.client.common.AbstractApi;
import com.opensearchserver.client.common.JsonClientAbstract;
import com.opensearchserver.utils.HttpUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;

public class DictionaryApi1
extends AbstractApi<JsonClientAbstract> {
    public DictionaryApi1(JsonClient1 client) {
        super(client);
    }

    public void createSynonymsList(String indexName, String listName, String listSynonyms) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/synonyms/", listName);
        Request request = Request.Put((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, listSynonyms, null);
        HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200});
    }

    public boolean checkSynonymsListExists(String indexName, String listName) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/synonyms/", listName);
        Request request = Request.Head((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, null, null);
        switch (HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200, 404})) {
            case 200: {
                return true;
            }
            case 404: {
                return false;
            }
        }
        return false;
    }

    public void deleteSynonymsList(String indexName, String listName) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/synonyms/", listName);
        Request request = Request.Delete((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, null, null);
        HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200});
    }

    public void createStopWordsList(String indexName, String listName, String stopwordsList) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/stopwords/", listName);
        Request request = Request.Put((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, stopwordsList, null);
        HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200});
    }

    public boolean checkStopWordsListExists(String indexName, String listName) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/stopwords/", listName);
        Request request = Request.Head((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, null, null);
        switch (HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200, 404})) {
            case 200: {
                return true;
            }
            case 404: {
                return false;
            }
        }
        return false;
    }

    public void deleteStopWordsList(String indexName, String listName) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/stopwords/", listName);
        Request request = Request.Delete((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, null, null);
        HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200});
    }
}

