/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.client.v1;

import com.opensearchserver.client.JsonClient1;
import com.opensearchserver.client.common.AbstractApi;
import com.opensearchserver.client.common.JsonClientAbstract;
import com.opensearchserver.client.common.LanguageEnum;
import com.opensearchserver.client.common.analyzer.AnalyzerItem;
import com.opensearchserver.utils.HttpUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;

public class AnalyzerApi1
extends AbstractApi<JsonClientAbstract> {
    public AnalyzerApi1(JsonClient1 client) {
        super(client);
    }

    public boolean checkAnalyzerExists(String indexName, String analyzerName, LanguageEnum analyzerLang) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/analyzer/", analyzerName, "/lang/", analyzerLang.toString());
        Request request = Request.Get((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, null, null);
        switch (HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200, 404})) {
            case 200: {
                return true;
            }
            case 404: {
                return false;
            }
        }
        return false;
    }

    public void createAnalyzer(String indexName, AnalyzerItem analyzer, String analyzerName, LanguageEnum analyzerLang) throws ClientProtocolException, UnsupportedEncodingException, IOException, URISyntaxException {
        URIBuilder uriBuilder = this.client.getBaseUrl("index/", indexName, "/analyzer/", analyzerName, "/lang/", analyzerLang.toString());
        Request request = Request.Put((URI)uriBuilder.build());
        HttpResponse response = this.client.execute(request, analyzer, null);
        HttpUtils.checkStatusCodes((HttpResponse)response, (int[])new int[]{200});
    }
}

