/*
 * Decompiled with CFR 0.152.
 */
package com.omh.android.auth.nongms.domain.auth;

import com.omh.android.auth.nongms.domain.auth.AuthRepository;
import com.omh.android.auth.nongms.domain.auth.AuthUseCase;
import com.omh.android.auth.nongms.domain.models.ApiResult;
import com.omh.android.auth.nongms.domain.models.OAuthTokens;
import com.omh.android.auth.nongms.domain.utils.Pkce;
import com.omh.android.auth.nongms.domain.utils.PkceImpl;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\tJ\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u0010\u001a\u00020\u0011J/\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lcom/omh/android/auth/nongms/domain/auth/AuthUseCase;", "", "authRepository", "Lcom/omh/android/auth/nongms/domain/auth/AuthRepository;", "pkce", "Lcom/omh/android/auth/nongms/domain/utils/Pkce;", "(Lcom/omh/android/auth/nongms/domain/auth/AuthRepository;Lcom/omh/android/auth/nongms/domain/utils/Pkce;)V", "blockingRefreshToken", "Lcom/omh/android/auth/nongms/domain/models/ApiResult;", "", "clientId", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAccessToken", "getLoginUrl", "scopes", "packageName", "logout", "", "requestTokens", "Lcom/omh/android/auth/nongms/domain/models/OAuthTokens;", "authCode", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "revokeToken", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "auth-api-non-gms_release"})
public final class AuthUseCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthRepository authRepository;
    @NotNull
    private final Pkce pkce;
    @NotNull
    public static final String REDIRECT_FORMAT = "%s:/oauth2redirect";

    public AuthUseCase(@NotNull AuthRepository authRepository, @NotNull Pkce pkce) {
        Intrinsics.checkNotNullParameter((Object)authRepository, (String)"authRepository");
        Intrinsics.checkNotNullParameter((Object)pkce, (String)"pkce");
        this.authRepository = authRepository;
        this.pkce = pkce;
    }

    @NotNull
    public final String getLoginUrl(@NotNull String scopes, @NotNull String packageName, @NotNull String clientId) {
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        String string = this.pkce.generateCodeChallenge();
        String string2 = REDIRECT_FORMAT;
        Object[] objectArray = new Object[]{packageName};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        return this.authRepository.buildLoginUrl(scopes, clientId, string, string3);
    }

    @Nullable
    public final Object requestTokens(@NotNull String authCode, @NotNull String packageName, @NotNull String clientId, @NotNull Continuation<? super ApiResult<OAuthTokens>> $completion) {
        String string = REDIRECT_FORMAT;
        Object[] objectArray = new Object[]{packageName};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return this.authRepository.requestTokens(clientId, authCode, string2, this.pkce.getCodeVerifier(), $completion);
    }

    @Nullable
    public final Object blockingRefreshToken(@NotNull String clientId, @NotNull Continuation<? super ApiResult<String>> $completion) {
        return this.authRepository.refreshAccessToken(clientId, $completion);
    }

    @Nullable
    public final String getAccessToken() {
        return this.authRepository.getAccessToken();
    }

    public final void logout() {
        this.authRepository.clearData();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object revokeToken(@NotNull Continuation<? super ApiResult<Unit>> var1_1) {
        if (!(var1_1 instanceof revokeToken.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AuthUseCase this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.revokeToken((Continuation<? super ApiResult<Unit>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.authRepository.revokeToken((Continuation<? super ApiResult<Unit>>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (AuthUseCase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if ((result = (ApiResult)v0) instanceof ApiResult.Success) {
                    this.authRepository.clearData();
                }
                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/omh/android/auth/nongms/domain/auth/AuthUseCase$Companion;", "", "()V", "REDIRECT_FORMAT", "", "createAuthUseCase", "Lcom/omh/android/auth/nongms/domain/auth/AuthUseCase;", "authRepository", "Lcom/omh/android/auth/nongms/domain/auth/AuthRepository;", "auth-api-non-gms_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AuthUseCase createAuthUseCase(@NotNull AuthRepository authRepository) {
            Intrinsics.checkNotNullParameter((Object)authRepository, (String)"authRepository");
            return new AuthUseCase(authRepository, new PkceImpl());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

