/*
 * Decompiled with CFR 0.152.
 */
package com.omh.android.auth.nongms.data.utils.retrofit;

import com.omh.android.auth.nongms.domain.models.ApiResult;
import java.io.IOException;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002:\u0001\u0017B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0002H\u0016J\u001c\u0010\u000b\u001a\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\rH\u0016J\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/omh/android/auth/nongms/data/utils/retrofit/ApiResultCall;", "T", "Lretrofit2/Call;", "Lcom/omh/android/auth/nongms/domain/models/ApiResult;", "delegate", "successType", "Ljava/lang/reflect/Type;", "(Lretrofit2/Call;Ljava/lang/reflect/Type;)V", "cancel", "", "clone", "enqueue", "callback", "Lretrofit2/Callback;", "execute", "Lretrofit2/Response;", "isCanceled", "", "isExecuted", "request", "Lokhttp3/Request;", "timeout", "Lokio/Timeout;", "ApiResultCallback", "auth-api-non-gms_release"})
public final class ApiResultCall<T>
implements Call<ApiResult<? extends T>> {
    @NotNull
    private final Call<T> delegate;
    @NotNull
    private final Type successType;

    public ApiResultCall(@NotNull Call<T> delegate, @NotNull Type successType) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)successType, (String)"successType");
        this.delegate = delegate;
        this.successType = successType;
    }

    public void enqueue(@NotNull Callback<ApiResult<T>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.delegate.enqueue((Callback)new ApiResultCallback(callback));
    }

    @NotNull
    public Call<ApiResult<T>> clone() {
        Call call = this.delegate.clone();
        Intrinsics.checkNotNull((Object)call, (String)"null cannot be cast to non-null type retrofit2.Call<com.omh.android.auth.nongms.domain.models.ApiResult<T of com.omh.android.auth.nongms.data.utils.retrofit.ApiResultCall>>");
        return call;
    }

    @NotNull
    public Response<ApiResult<T>> execute() {
        Response response = this.delegate.execute();
        Intrinsics.checkNotNull((Object)response, (String)"null cannot be cast to non-null type retrofit2.Response<com.omh.android.auth.nongms.domain.models.ApiResult<T of com.omh.android.auth.nongms.data.utils.retrofit.ApiResultCall>>");
        return response;
    }

    public boolean isExecuted() {
        return this.delegate.isExecuted();
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled();
    }

    @NotNull
    public Request request() {
        Request request = this.delegate.request();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"delegate.request()");
        return request;
    }

    @NotNull
    public Timeout timeout() {
        Timeout timeout = this.delegate.timeout();
        Intrinsics.checkNotNullExpressionValue((Object)timeout, (String)"delegate.timeout()");
        return timeout;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0001\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003*\b\u0012\u0004\u0012\u00028\u00000\rH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/omh/android/auth/nongms/data/utils/retrofit/ApiResultCall$ApiResultCallback;", "Lretrofit2/Callback;", "callback", "Lcom/omh/android/auth/nongms/domain/models/ApiResult;", "(Lcom/omh/android/auth/nongms/data/utils/retrofit/ApiResultCall;Lretrofit2/Callback;)V", "onFailure", "", "call", "Lretrofit2/Call;", "throwable", "", "onResponse", "response", "Lretrofit2/Response;", "toApiResult", "auth-api-non-gms_release"})
    public final class ApiResultCallback
    implements Callback<T> {
        @NotNull
        private final Callback<ApiResult<T>> callback;

        public ApiResultCallback(Callback<ApiResult<T>> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.callback = callback;
        }

        public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
            Intrinsics.checkNotNullParameter(call, (String)"call");
            Intrinsics.checkNotNullParameter(response, (String)"response");
            Response response2 = Response.success(this.toApiResult(response));
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"success(response.toApiResult())");
            Response apiResponse = response2;
            this.callback.onResponse((Call)ApiResultCall.this, apiResponse);
        }

        public void onFailure(@NotNull Call<T> call, @NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter(call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            ApiResult.Error apiResult = throwable instanceof IOException ? (ApiResult.Error)new ApiResult.Error.NetworkError(throwable) : (ApiResult.Error)new ApiResult.Error.RuntimeError(throwable);
            this.callback.onResponse((Call)ApiResultCall.this, Response.success((Object)apiResult));
        }

        private final ApiResult<T> toApiResult(Response<T> $this$toApiResult) {
            ApiResult apiResult;
            if (!$this$toApiResult.isSuccessful()) {
                apiResult = new ApiResult.Error.ApiError(new HttpException($this$toApiResult));
            } else if ($this$toApiResult.body() != null) {
                Object object = $this$toApiResult.body();
                Intrinsics.checkNotNull((Object)object);
                apiResult = new ApiResult.Success<Object>(object);
            } else if (Intrinsics.areEqual((Object)ApiResultCall.this.successType, Unit.class)) {
                apiResult = new ApiResult.Success<Unit>(Unit.INSTANCE);
            } else {
                UnknownError exception = new UnknownError("Response body was null");
                apiResult = new ApiResult.Error.RuntimeError(exception);
            }
            return apiResult;
        }
    }
}

