/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import com.ogury.core.OguryError;
import com.ogury.ed.OguryBannerAdListener;
import com.ogury.ed.OguryBannerAdSize;
import com.ogury.ed.OguryBannerAdView;
import com.ogury.sdk.Ogury;
import com.ogury.sdk.OguryConfiguration;
import com.openmediation.sdk.mediation.AdapterErrorBuilder;
import com.openmediation.sdk.mediation.CustomBannerEvent;
import com.openmediation.sdk.utils.AdLog;
import java.util.Map;

public class OguryBanner
extends CustomBannerEvent
implements OguryBannerAdListener {
    private static final String TAG = "OguryBanner ";
    private OguryBannerAdView mBannerAd;

    public void loadAd(Activity activity, Map<String, String> config) throws Throwable {
        super.loadAd(activity, config);
        if (activity == null || activity.isFinishing()) {
            return;
        }
        if (!this.check(activity, config)) {
            return;
        }
        OguryBannerAdSize size = this.getAdSize(config);
        if (size == null) {
            this.onInsError(AdapterErrorBuilder.buildLoadError((String)"Banner", (String)this.mAdapterName, (String)("Unsupported Banner Size: " + this.getBannerDesc(config))));
        }
        this.initSdk(activity, config);
        this.mBannerAd = new OguryBannerAdView((Context)activity);
        this.mBannerAd.setAdUnit(this.mInstancesKey);
        this.mBannerAd.setAdSize(OguryBannerAdSize.SMALL_BANNER_320x50);
        this.mBannerAd.setListener((OguryBannerAdListener)this);
        this.mBannerAd.loadAd();
    }

    public int getMediation() {
        return 13;
    }

    public void destroy(Activity activity) {
        this.isDestroyed = true;
        if (this.mBannerAd != null) {
            this.mBannerAd.destroy();
        }
    }

    public void onAdLoaded() {
        if (this.isDestroyed) {
            return;
        }
        AdLog.getSingleton().LogE("OguryBanner Banner Load Success");
        this.onInsReady(this.mBannerAd);
    }

    public void onAdDisplayed() {
        AdLog.getSingleton().LogE("OguryBanner Banner onAdDisplayed");
    }

    public void onAdClicked() {
        AdLog.getSingleton().LogE("OguryBanner Banner onAdClicked");
        if (this.isDestroyed) {
            return;
        }
        this.onInsClicked();
    }

    public void onAdClosed() {
        AdLog.getSingleton().LogE("OguryBanner Banner onAdClosed");
    }

    public void onAdError(OguryError oguryError) {
        AdLog.getSingleton().LogE("OguryBanner Banner onAdError: " + oguryError);
        if (this.isDestroyed) {
            return;
        }
        this.onInsError(AdapterErrorBuilder.buildLoadError((String)"Banner", (String)this.mAdapterName, (int)oguryError.getErrorCode(), (String)oguryError.getMessage()));
    }

    private void initSdk(Activity activity, Map<String, String> config) {
        String appKey = config.get("AppKey");
        OguryConfiguration.Builder configurationBuilder = new OguryConfiguration.Builder(activity.getApplicationContext(), appKey);
        Ogury.start((OguryConfiguration)configurationBuilder.build());
    }

    private OguryBannerAdSize getAdSize(Map<String, String> config) {
        String desc = this.getBannerDesc(config);
        if ("BANNER".equals(desc)) {
            return OguryBannerAdSize.SMALL_BANNER_320x50;
        }
        if ("RECTANGLE".equals(desc)) {
            return OguryBannerAdSize.MPU_300x250;
        }
        if ("LEADERBOARD".equals(desc)) {
            return null;
        }
        return OguryBannerAdSize.SMALL_BANNER_320x50;
    }
}

