/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.text.TextUtils;
import com.ogury.core.OguryError;
import com.ogury.ed.OguryInterstitialAd;
import com.ogury.ed.OguryInterstitialAdListener;
import com.ogury.ed.OguryOptinVideoAd;
import com.ogury.ed.OguryOptinVideoAdListener;
import com.ogury.ed.OguryReward;
import com.ogury.sdk.Ogury;
import com.ogury.sdk.OguryConfiguration;
import com.openmediation.sdk.mediation.AdapterError;
import com.openmediation.sdk.mediation.AdapterErrorBuilder;
import com.openmediation.sdk.mediation.CustomAdsAdapter;
import com.openmediation.sdk.mediation.InterstitialAdCallback;
import com.openmediation.sdk.mediation.RewardedVideoCallback;
import com.openmediation.sdk.utils.AdLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class OguryAdapter
extends CustomAdsAdapter {
    private static final String TAG = "OguryAdapter ";
    private final ConcurrentMap<String, OguryOptinVideoAd> mRewardedAds;
    private final ConcurrentMap<String, OguryInterstitialAd> mInterstitialAds;
    private final AtomicBoolean hasInit = new AtomicBoolean(false);

    public OguryAdapter() {
        this.mRewardedAds = new ConcurrentHashMap<String, OguryOptinVideoAd>();
        this.mInterstitialAds = new ConcurrentHashMap<String, OguryInterstitialAd>();
    }

    public String getMediationVersion() {
        return Ogury.getSdkVersion();
    }

    public String getAdapterVersion() {
        return "1.0.0";
    }

    public int getAdNetworkId() {
        return 22;
    }

    public boolean isInterstitialAdAvailable(String adUnitId) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            return false;
        }
        OguryInterstitialAd interstitialAd = (OguryInterstitialAd)this.mInterstitialAds.get(adUnitId);
        return interstitialAd != null && interstitialAd.isLoaded();
    }

    public void initInterstitialAd(Activity activity, Map<String, Object> dataMap, InterstitialAdCallback callback) {
        super.initInterstitialAd(activity, dataMap, callback);
        String error = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)error)) {
            AdLog.getSingleton().LogE("OguryAdapter \u63d2\u5c4f\u5e7f\u544a\u521d\u59cb\u5316\u6210\u529f...");
            this.initSdk(activity);
            if (callback != null) {
                callback.onInterstitialAdInitSuccess();
            }
        } else {
            AdLog.getSingleton().LogE("OguryAdapter \u63d2\u5c4f\u5e7f\u544a\u521d\u59cb\u5316\u5931\u8d25...");
            if (callback != null) {
                callback.onInterstitialAdInitFailed(AdapterErrorBuilder.buildInitError((String)"Interstitial", (String)this.mAdapterName, (String)error));
            }
        }
    }

    public void loadInterstitialAd(Activity activity, String adUnitId, Map<String, Object> extras, InterstitialAdCallback callback) {
        super.loadInterstitialAd(activity, adUnitId, extras, callback);
        AdLog.getSingleton().LogE("OguryAdapter \u63d2\u5c4f\u5e7f\u544a\u5f00\u59cb\u52a0\u8f7d... ");
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            if (callback != null) {
                callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Interstitial", (String)this.mAdapterName, (String)error));
            }
            return;
        }
        OguryInterstitialAd interstitialPlacement = new OguryInterstitialAd(activity.getApplicationContext(), adUnitId);
        this.mInterstitialAds.put(adUnitId, interstitialPlacement);
        interstitialPlacement.setListener(this.createInterstitialListener(adUnitId, callback));
        interstitialPlacement.load();
    }

    private OguryInterstitialAdListener createInterstitialListener(final String adUnitId, final InterstitialAdCallback callback) {
        return new OguryInterstitialAdListener(){

            public void onAdLoaded() {
                AdLog.getSingleton().LogE("OguryAdapter \u63d2\u5c4f\u5e7f\u544a\u5df2\u52a0\u8f7d\u597d");
                if (callback != null) {
                    callback.onInterstitialAdLoadSuccess();
                }
            }

            public void onAdDisplayed() {
                AdLog.getSingleton().LogE("OguryAdapter \u63d2\u5c4f\u5e7f\u544a\u5c55\u793a");
                if (callback != null) {
                    callback.onInterstitialAdShowSuccess();
                }
            }

            public void onAdClicked() {
                if (callback != null) {
                    callback.onInterstitialAdClick();
                }
            }

            public void onAdClosed() {
                AdLog.getSingleton().LogE("OguryAdapter \u63d2\u5c4f\u5e7f\u544a\u5173\u95ed");
                OguryAdapter.this.mInterstitialAds.remove(adUnitId);
                if (callback != null) {
                    callback.onInterstitialAdClosed();
                }
            }

            public void onAdError(OguryError oguryError) {
                AdLog.getSingleton().LogE("OguryAdapter \u63d2\u5c4f\u5e7f\u544a\u52a0\u8f7d\u51fa\u9519");
                OguryAdapter.this.mInterstitialAds.remove(adUnitId);
                if (callback != null) {
                    AdapterError adapterError = AdapterErrorBuilder.buildLoadError((String)"Interstitial", (String)OguryAdapter.this.mAdapterName, (int)oguryError.getErrorCode(), (String)oguryError.getMessage());
                    callback.onInterstitialAdLoadFailed(adapterError);
                }
            }
        };
    }

    public void showInterstitialAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        super.showInterstitialAd(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            if (callback != null) {
                callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (String)error));
            }
            return;
        }
        if (!this.isInterstitialAdAvailable(adUnitId)) {
            if (callback != null) {
                callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (String)"ad not ready"));
            }
            return;
        }
        OguryInterstitialAd ad = (OguryInterstitialAd)this.mInterstitialAds.get(adUnitId);
        if (ad != null) {
            ad.show();
        } else if (callback != null) {
            callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (String)"ad not ready"));
        }
    }

    public void initRewardedVideo(Activity activity, Map<String, Object> dataMap, RewardedVideoCallback callback) {
        super.initRewardedVideo(activity, dataMap, callback);
        String error = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)error)) {
            this.initSdk(activity);
            if (callback != null) {
                AdLog.getSingleton().LogE("OguryAdapter \u6fc0\u52b1\u5e7f\u544a\u521d\u59cb\u5316\u6210\u529f...");
                callback.onRewardedVideoInitSuccess();
            }
        } else if (callback != null) {
            AdLog.getSingleton().LogE("OguryAdapter \u6fc0\u52b1\u5e7f\u544a\u521d\u59cb\u5316\u5931\u8d25...");
            callback.onRewardedVideoInitFailed(AdapterErrorBuilder.buildInitError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
        }
    }

    public boolean isRewardedVideoAvailable(String adUnitId) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            return false;
        }
        OguryOptinVideoAd videoAd = (OguryOptinVideoAd)this.mRewardedAds.get(adUnitId);
        return videoAd != null && videoAd.isLoaded();
    }

    public void loadRewardedVideo(Activity activity, String adUnitId, Map<String, Object> extras, RewardedVideoCallback callback) {
        super.loadRewardedVideo(activity, adUnitId, extras, callback);
        AdLog.getSingleton().LogE("OguryAdapter \u6fc0\u52b1\u5e7f\u544a\u5f00\u59cb\u52a0\u8f7d...");
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            if (callback != null) {
                callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
            }
            return;
        }
        OguryOptinVideoAd rewardedPlacement = new OguryOptinVideoAd(activity.getApplicationContext(), adUnitId);
        rewardedPlacement.setListener(this.createRvLoadListener(adUnitId, callback));
        this.mRewardedAds.put(adUnitId, rewardedPlacement);
        rewardedPlacement.load();
    }

    private void initSdk(Activity activity) {
        if (!this.hasInit.get()) {
            OguryConfiguration.Builder configurationBuilder = new OguryConfiguration.Builder(activity.getApplicationContext(), this.mAppKey);
            Ogury.start((OguryConfiguration)configurationBuilder.build());
            this.hasInit.set(true);
        }
    }

    public void showRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            if (callback != null) {
                callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
            }
            return;
        }
        if (!this.isRewardedVideoAvailable(adUnitId)) {
            if (callback != null) {
                callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)"Not Ready"));
            }
            return;
        }
        OguryOptinVideoAd ad = (OguryOptinVideoAd)this.mRewardedAds.get(adUnitId);
        if (ad != null) {
            ad.show();
        } else if (callback != null) {
            callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)"Not Ready"));
        }
    }

    private OguryOptinVideoAdListener createRvLoadListener(final String adUnitId, final RewardedVideoCallback callback) {
        return new OguryOptinVideoAdListener(){

            public void onAdLoaded() {
                AdLog.getSingleton().LogE("OguryAdapter \u6fc0\u52b1\u5e7f\u544a\u52a0\u8f7d\u6210\u529f...");
                if (callback != null) {
                    callback.onRewardedVideoLoadSuccess();
                }
            }

            public void onAdDisplayed() {
                AdLog.getSingleton().LogE("OguryAdapter \u6fc0\u52b1\u5e7f\u544a\u663e\u793a...");
                if (callback != null) {
                    callback.onRewardedVideoAdShowSuccess();
                    callback.onRewardedVideoAdStarted();
                }
            }

            public void onAdClicked() {
                if (callback != null) {
                    callback.onRewardedVideoAdClicked();
                }
            }

            public void onAdClosed() {
                AdLog.getSingleton().LogE("OguryAdapter \u6fc0\u52b1\u5e7f\u544a\u5173\u95ed...");
                OguryAdapter.this.mRewardedAds.remove(adUnitId);
                if (callback != null) {
                    callback.onRewardedVideoAdEnded();
                    callback.onRewardedVideoAdClosed();
                }
            }

            public void onAdError(OguryError oguryError) {
                AdLog.getSingleton().LogE("OguryAdapter \u6fc0\u52b1\u5e7f\u544a\u52a0\u8f7d\u9519\u8bef...\u9519\u8bef\u7801\uff1a" + oguryError);
                if (callback != null) {
                    callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Rewarded Video", (String)OguryAdapter.this.mAdapterName, (int)oguryError.getErrorCode(), (String)oguryError.getMessage()));
                }
            }

            public void onAdRewarded(OguryReward oguryReward) {
                AdLog.getSingleton().LogE("OguryAdapter \u83b7\u53d6\u5956\u52b1...");
                if (callback != null) {
                    callback.onRewardedVideoAdRewarded();
                }
            }
        };
    }
}

