/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.mintegral.msdk.out.SDKInitStatusListener;
import com.mintegral.msdk.system.a;
import com.openmediation.sdk.utils.AdLog;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class MintegralSingleTon {
    private InitState mInitState = InitState.NOT_INIT;
    private final List<InitCallback> mCallbacks = new CopyOnWriteArrayList<InitCallback>();

    private MintegralSingleTon() {
    }

    public static MintegralSingleTon getInstance() {
        return MintegralHolder.INSTANCE;
    }

    public void initSDK(final Context context, final String appKey, InitCallback listener) {
        if (context == null || TextUtils.isEmpty((CharSequence)appKey)) {
            if (listener != null) {
                AdLog.getSingleton().LogE("Init Failed: Context or AppKey is null");
                listener.onFailed("Init Failed: Context or AppKey is null");
            }
            return;
        }
        if (InitState.INIT_SUCCESS == this.mInitState) {
            if (listener != null) {
                listener.onSuccess();
            }
            return;
        }
        if (listener != null) {
            this.mCallbacks.add(listener);
        }
        if (InitState.INIT_PENDING == this.mInitState) {
            return;
        }
        this.mInitState = InitState.INIT_PENDING;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MintegralSingleTon.this.initSDK(context, appKey);
            }
        };
        if (Looper.getMainLooper() == Looper.myLooper()) {
            runnable.run();
            return;
        }
        new Handler(Looper.getMainLooper()).post(runnable);
    }

    private void initSDK(Context context, String appKey) {
        try {
            String[] tmp = appKey.split("#");
            String appId = tmp[0];
            String key = tmp[1];
            a sdk = MIntegralSDKFactory.getMIntegralSDK();
            Map map = sdk.getMTGConfigurationMap(appId, key);
            sdk.init(map, context.getApplicationContext(), new SDKInitStatusListener(){

                public void onInitSuccess() {
                    MintegralSingleTon.this.initSuccess();
                }

                public void onInitFail() {
                    MintegralSingleTon.this.initError("Mintegral SDK Init Failed");
                }
            });
        }
        catch (Exception e) {
            this.initError("Mintegral SDK Init Failed: " + e.getMessage());
        }
    }

    private void initSuccess() {
        AdLog.getSingleton().LogD("Mintegral SDK Init Success");
        this.mInitState = InitState.INIT_SUCCESS;
        for (InitCallback callback : this.mCallbacks) {
            if (callback == null) continue;
            callback.onSuccess();
        }
        this.mCallbacks.clear();
    }

    private void initError(String error) {
        AdLog.getSingleton().LogE(error);
        this.mInitState = InitState.INIT_FAIL;
        for (InitCallback callback : this.mCallbacks) {
            if (callback == null) continue;
            callback.onFailed(error);
        }
        this.mCallbacks.clear();
    }

    public InitState getInitState() {
        return this.mInitState;
    }

    public static interface InitCallback {
        public void onSuccess();

        public void onFailed(String var1);
    }

    public static enum InitState {
        NOT_INIT,
        INIT_PENDING,
        INIT_SUCCESS,
        INIT_FAIL;

    }

    private static class MintegralHolder {
        private static final MintegralSingleTon INSTANCE = new MintegralSingleTon();

        private MintegralHolder() {
        }
    }
}

