/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.mintegral.msdk.out.BannerAdListener;
import com.mintegral.msdk.out.BannerSize;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.mintegral.msdk.out.MTGBannerView;
import com.mintegral.msdk.system.a;
import com.openmediation.sdk.mediation.AdapterErrorBuilder;
import com.openmediation.sdk.mediation.CustomBannerEvent;
import com.openmediation.sdk.mobileads.MintegralSingleTon;
import java.util.Map;

public class MintegralBanner
extends CustomBannerEvent
implements BannerAdListener {
    private static final String PAY_LOAD = "pay_load";
    private MTGBannerView mBannerView;

    public void setGDPRConsent(Context context, boolean consent) {
        super.setGDPRConsent(context, consent);
        if (context != null) {
            a sdk = MIntegralSDKFactory.getMIntegralSDK();
            int consentStatus = consent ? 1 : 0;
            sdk.setConsentStatus(context, consentStatus);
        }
    }

    public void setUSPrivacyLimit(Context context, boolean value) {
        super.setUSPrivacyLimit(context, value);
        a sdk = MIntegralSDKFactory.getMIntegralSDK();
        sdk.setDoNotTrackStatus(value);
    }

    public void loadAd(final Activity activity, final Map<String, String> config) throws Throwable {
        super.loadAd(activity, config);
        if (!this.check(activity, config)) {
            return;
        }
        MintegralSingleTon.getInstance().initSDK((Context)activity, config.get("AppKey"), new MintegralSingleTon.InitCallback(){

            @Override
            public void onSuccess() {
                if (MintegralBanner.this.mUserAge != null) {
                    MintegralBanner.this.setUserAge((Context)activity, MintegralBanner.this.mUserAge);
                }
                if (MintegralBanner.this.mUserGender != null) {
                    MintegralBanner.this.setUserGender((Context)activity, MintegralBanner.this.mUserGender);
                }
                MintegralBanner.this.loadBanner(activity, config);
            }

            @Override
            public void onFailed(String msg) {
                if (!MintegralBanner.this.isDestroyed) {
                    MintegralBanner.this.onInsError(AdapterErrorBuilder.buildLoadError((String)"Banner", (String)MintegralBanner.this.mAdapterName, (String)msg));
                }
            }
        });
    }

    private void loadBanner(Activity activity, Map<String, String> config) {
        String payload = "";
        if (config.containsKey(PAY_LOAD)) {
            payload = config.get(PAY_LOAD);
        }
        if (this.mBannerView != null) {
            if (TextUtils.isEmpty((CharSequence)payload)) {
                this.mBannerView.load();
            } else {
                this.mBannerView.loadFromBid(payload);
            }
            return;
        }
        this.mBannerView = new MTGBannerView(activity.getApplicationContext());
        BannerSize adSize = this.getAdSize(activity, config);
        this.mBannerView.init(adSize, "", this.mInstancesKey);
        this.mBannerView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(MintegralBanner.dip2px((Context)activity, adSize.getWidth()), MintegralBanner.dip2px((Context)activity, adSize.getHeight())));
        this.mBannerView.setAllowShowCloseBtn(false);
        this.mBannerView.setRefreshTime(0);
        this.mBannerView.setBannerAdListener((BannerAdListener)this);
        if (TextUtils.isEmpty((CharSequence)payload)) {
            this.mBannerView.load();
        } else {
            this.mBannerView.loadFromBid(payload);
        }
    }

    private static int dip2px(Context context, float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public int getMediation() {
        return 14;
    }

    public void destroy(Activity activity) {
        if (this.mBannerView != null) {
            this.mBannerView.release();
            this.mBannerView = null;
        }
        this.isDestroyed = true;
    }

    private BannerSize getAdSize(Activity activity, Map<String, String> config) {
        String bannerDesc;
        switch (bannerDesc = this.getBannerDesc(config)) {
            case "LEADERBOARD": {
                return new BannerSize(5, 728, 90);
            }
            case "RECTANGLE": {
                return new BannerSize(2, 300, 250);
            }
            case "SMART": {
                if (!MintegralBanner.isLargeScreen((Context)activity)) break;
                return new BannerSize(5, 728, 90);
            }
        }
        return new BannerSize(4, 320, 50);
    }

    public void onLoadFailed(String s) {
        if (!this.isDestroyed) {
            this.onInsError(AdapterErrorBuilder.buildLoadError((String)"Banner", (String)this.mAdapterName, (String)s));
        }
    }

    public void onLoadSuccessed() {
        if (!this.isDestroyed) {
            this.onInsReady(this.mBannerView);
        }
    }

    public void onLogImpression() {
    }

    public void onClick() {
        if (!this.isDestroyed) {
            this.onInsClicked();
        }
    }

    public void onLeaveApp() {
    }

    public void showFullScreen() {
    }

    public void closeFullScreen() {
    }

    public void onCloseBanner() {
    }
}

