/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.content.Context;
import android.text.TextUtils;
import com.mintegral.msdk.mtgbid.out.BidListennning;
import com.mintegral.msdk.mtgbid.out.BidLossCode;
import com.mintegral.msdk.mtgbid.out.BidManager;
import com.mintegral.msdk.mtgbid.out.BidResponsed;
import com.openmediation.sdk.bid.AdTimingBidResponse;
import com.openmediation.sdk.bid.BidAdapter;
import com.openmediation.sdk.bid.BidCallback;
import com.openmediation.sdk.bid.BidLoseReason;
import com.openmediation.sdk.mobileads.MintegralSingleTon;
import com.openmediation.sdk.utils.AdLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MintegralBidAdapter
extends BidAdapter {
    private static final String CLAZZ = "com.mintegral.msdk.mtgbid.out.BidManager";
    private ConcurrentHashMap<String, BidResponsed> mBidResponses = new ConcurrentHashMap();
    private Context mContext;

    public void initBid(Context context, Map<String, Object> dataMap, BidCallback callback) {
        super.initBid(context, dataMap, callback);
        if (context != null) {
            this.mContext = context.getApplicationContext();
            try {
                String appKey = String.valueOf(dataMap.get("app_key"));
                MintegralSingleTon.getInstance().initSDK(this.mContext, appKey, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getBiddingToken(Context context) {
        if (MintegralSingleTon.getInstance().isInit()) {
            try {
                Class<?> clazz = Class.forName(CLAZZ);
                return BidManager.getBuyerUid((Context)context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public void executeBid(Context context, Map<String, Object> dataMap, BidCallback callback) {
        block6: {
            super.executeBid(context, dataMap, callback);
            try {
                Class<?> clazz = Class.forName(CLAZZ);
                this.mContext = context.getApplicationContext();
                String unitId = (String)dataMap.get("placement_id");
                if (TextUtils.isEmpty((CharSequence)unitId)) {
                    if (callback != null) {
                        callback.bidFailed("Mintegral bid failed: unitId is null");
                    }
                    return;
                }
                BidManager manager = new BidManager("", unitId);
                manager.setBidListener((BidListennning)new BidResCallback(unitId, callback));
                manager.bid();
            }
            catch (ClassNotFoundException e) {
                AdLog.getSingleton().LogE("Mintegral bid sdk not integrated");
                if (callback != null) {
                    callback.bidFailed("Mintegral bid sdk not integrated");
                }
            }
            catch (Exception e) {
                AdLog.getSingleton().LogE("Mintegral bid failed: " + e.getMessage());
                if (callback == null) break block6;
                callback.bidFailed("Mintegral bid failed");
            }
        }
    }

    public void notifyWin(String placementId, Map<String, Object> dataMap) {
        BidResponsed bidResponsed;
        super.notifyWin(placementId, dataMap);
        if (this.mBidResponses.containsKey(placementId) && (bidResponsed = this.mBidResponses.get(placementId)) != null && this.mContext != null) {
            bidResponsed.sendWinNotice(this.mContext);
        }
    }

    public void notifyLose(String placementId, Map<String, Object> dataMap) {
        BidResponsed bidResponse;
        super.notifyLose(placementId, dataMap);
        if (this.mBidResponses.containsKey(placementId) && (bidResponse = this.mBidResponses.get(placementId)) != null && this.mContext != null) {
            int reason = -1;
            if (dataMap != null && dataMap.containsKey("notify_reason")) {
                reason = (Integer)dataMap.get("notify_reason");
            }
            BidLossCode lossCode = reason == BidLoseReason.LOST_TO_HIGHER_BIDDER.getValue() ? BidLossCode.bidPriceNotHighest() : (reason == BidLoseReason.TIMEOUT.getValue() ? BidLossCode.bidTimeOut() : BidLossCode.bidWinButNotShow());
            bidResponse.sendLossNotice(this.mContext, lossCode);
        }
    }

    private class BidResCallback
    implements BidListennning {
        private String mUnitId;
        private BidCallback mCallback;

        BidResCallback(String unitId, BidCallback callback) {
            this.mUnitId = unitId;
            this.mCallback = callback;
        }

        public void onFailed(String msg) {
            if (this.mCallback != null) {
                this.mCallback.bidFailed(msg);
            }
        }

        public void onSuccessed(BidResponsed bidResponsed) {
            if (bidResponsed == null) {
                return;
            }
            MintegralBidAdapter.this.mBidResponses.put(this.mUnitId, bidResponsed);
            AdTimingBidResponse response = new AdTimingBidResponse();
            response.setOriginal(bidResponsed.toString());
            response.setCur(bidResponsed.getCur());
            try {
                response.setPrice(Double.parseDouble(bidResponsed.getPrice()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            response.setPayLoad(bidResponsed.getBidToken());
            if (this.mCallback != null) {
                this.mCallback.bidSuccess(response);
            }
        }
    }
}

