/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.mintegral.msdk.interstitialvideo.out.InterstitialVideoListener;
import com.mintegral.msdk.interstitialvideo.out.MTGBidInterstitialVideoHandler;
import com.mintegral.msdk.interstitialvideo.out.MTGInterstitialVideoHandler;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.mintegral.msdk.out.MTGBidRewardVideoHandler;
import com.mintegral.msdk.out.MTGRewardVideoHandler;
import com.mintegral.msdk.out.RewardVideoListener;
import com.mintegral.msdk.out.SDKInitStatusListener;
import com.mintegral.msdk.system.a;
import com.mintegral.msdk.video.bt.module.b.g;
import com.openmediation.sdk.mediation.AdapterErrorBuilder;
import com.openmediation.sdk.mediation.CustomAdsAdapter;
import com.openmediation.sdk.mediation.InterstitialAdCallback;
import com.openmediation.sdk.mediation.RewardedVideoCallback;
import com.openmediation.sdk.mobileads.MintegralSingleTon;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MintegralAdapter
extends CustomAdsAdapter {
    private static final String PAY_LOAD = "pay_load";
    private ConcurrentHashMap<String, MTGInterstitialVideoHandler> mInterstitialAds = new ConcurrentHashMap();
    private ConcurrentHashMap<String, MTGRewardVideoHandler> mRvAds = new ConcurrentHashMap();
    private ConcurrentHashMap<String, MTGBidInterstitialVideoHandler> mInterstitialBidAds;
    private ConcurrentHashMap<String, MTGBidRewardVideoHandler> mRvBidAds = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Boolean> mBidAdUnits;

    public MintegralAdapter() {
        this.mInterstitialBidAds = new ConcurrentHashMap();
        this.mBidAdUnits = new ConcurrentHashMap();
    }

    public String getMediationVersion() {
        return "MAL_15.3.11";
    }

    public String getAdapterVersion() {
        return "2.0.0";
    }

    public int getAdNetworkId() {
        return 14;
    }

    public void setGDPRConsent(Context context, boolean consent) {
        super.setGDPRConsent(context, consent);
        if (context != null) {
            a sdk = MIntegralSDKFactory.getMIntegralSDK();
            int consentStatus = consent ? 1 : 0;
            sdk.setConsentStatus(context, consentStatus);
        }
    }

    public void setUSPrivacyLimit(Context context, boolean value) {
        super.setUSPrivacyLimit(context, value);
        a sdk = MIntegralSDKFactory.getMIntegralSDK();
        sdk.setDoNotTrackStatus(value);
    }

    public void initRewardedVideo(final Activity activity, Map<String, Object> dataMap, final RewardedVideoCallback callback) {
        super.initRewardedVideo(activity, dataMap, callback);
        String error = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)error)) {
            this.initSDK(activity.getApplicationContext(), new SDKInitStatusListener(){

                public void onInitSuccess() {
                    if (callback != null) {
                        callback.onRewardedVideoInitSuccess();
                    }
                    MintegralAdapter.this.setCustomParam((Context)activity);
                }

                public void onInitFail() {
                    if (callback != null) {
                        callback.onRewardedVideoInitFailed(AdapterErrorBuilder.buildInitError((String)"Rewarded Video", (String)MintegralAdapter.this.mAdapterName, (String)"Mintegral Init Failed"));
                    }
                }
            });
        } else if (callback != null) {
            callback.onRewardedVideoInitFailed(AdapterErrorBuilder.buildInitError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
        }
    }

    public void loadRewardedVideo(Activity activity, String adUnitId, Map<String, Object> extras, RewardedVideoCallback callback) {
        super.loadRewardedVideo(activity, adUnitId, extras, callback);
        this.realLoadRvAd(activity, adUnitId, extras, callback);
    }

    private void realLoadRvAd(final Activity activity, final String adUnitId, final Map<String, Object> extras, final RewardedVideoCallback callback) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        String error = MintegralAdapter.this.check(activity, adUnitId);
                        if (TextUtils.isEmpty((CharSequence)error)) {
                            String payload = "";
                            if (extras != null && extras.containsKey(MintegralAdapter.PAY_LOAD)) {
                                payload = String.valueOf(extras.get(MintegralAdapter.PAY_LOAD));
                            }
                            if (TextUtils.isEmpty((CharSequence)payload)) {
                                MintegralAdapter.this.mBidAdUnits.remove(adUnitId);
                                MintegralAdapter.this.loadRvAd(activity, adUnitId, callback);
                            } else {
                                MintegralAdapter.this.mBidAdUnits.put(adUnitId, true);
                                MintegralAdapter.this.loadRvAdWithBid(activity, adUnitId, payload, callback);
                            }
                        } else if (callback != null) {
                            callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Rewarded Video", (String)MintegralAdapter.this.mAdapterName, (String)error));
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block8;
                        callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Rewarded Video", (String)MintegralAdapter.this.mAdapterName, (String)e.getMessage()));
                    }
                }
            }
        });
    }

    private void loadRvAd(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        MTGRewardVideoHandler rewardVideoHandler = this.mRvAds.get(adUnitId);
        if (rewardVideoHandler == null) {
            rewardVideoHandler = new MTGRewardVideoHandler((Context)activity, "", adUnitId);
            this.mRvAds.put(adUnitId, rewardVideoHandler);
            rewardVideoHandler.setRewardVideoListener((g)new MtgRvAdListener(callback));
        }
        if (rewardVideoHandler.isReady()) {
            if (callback != null) {
                callback.onRewardedVideoLoadSuccess();
            }
        } else {
            rewardVideoHandler.load();
        }
    }

    private void loadRvAdWithBid(Activity activity, String adUnitId, String payload, RewardedVideoCallback callback) {
        MTGBidRewardVideoHandler rewardVideoHandler = this.mRvBidAds.get(adUnitId);
        if (rewardVideoHandler == null) {
            rewardVideoHandler = new MTGBidRewardVideoHandler((Context)activity, "", adUnitId);
            this.mRvBidAds.put(adUnitId, rewardVideoHandler);
            rewardVideoHandler.setRewardVideoListener((g)new MtgRvAdListener(callback));
        }
        if (rewardVideoHandler.isBidReady()) {
            if (callback != null) {
                callback.onRewardedVideoLoadSuccess();
            }
        } else {
            rewardVideoHandler.loadFromBid(payload);
        }
    }

    public boolean isRewardedVideoAvailable(String adUnitId) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            return false;
        }
        if (this.mBidAdUnits.containsKey(adUnitId)) {
            MTGBidRewardVideoHandler videoHandler = this.mRvBidAds.get(adUnitId);
            return videoHandler != null && videoHandler.isBidReady();
        }
        MTGRewardVideoHandler rewardVideoHandler = this.mRvAds.get(adUnitId);
        return rewardVideoHandler != null && rewardVideoHandler.isReady();
    }

    public void showRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        super.showRewardedVideo(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            if (callback != null) {
                callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
            }
            return;
        }
        this.showRvAd(adUnitId, callback);
    }

    private void showRvAd(String adUnitId, RewardedVideoCallback callback) {
        if (this.mBidAdUnits.containsKey(adUnitId)) {
            MTGBidRewardVideoHandler rewardVideoHandler = this.mRvBidAds.get(adUnitId);
            if (rewardVideoHandler == null || !rewardVideoHandler.isBidReady()) {
                if (callback != null) {
                    callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)"MTGRewardedVideo Ad Not Ready"));
                }
                return;
            }
            rewardVideoHandler.showFromBid("1");
        } else {
            MTGRewardVideoHandler rewardVideoHandler = this.mRvAds.get(adUnitId);
            if (rewardVideoHandler == null || !rewardVideoHandler.isReady()) {
                if (callback != null) {
                    callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)"MTGRewardedVideo Ad Not Ready"));
                }
                return;
            }
            rewardVideoHandler.show("1");
        }
    }

    public void initInterstitialAd(final Activity activity, Map<String, Object> dataMap, final InterstitialAdCallback callback) {
        super.initInterstitialAd(activity, dataMap, callback);
        String error = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)error)) {
            this.initSDK(activity.getApplicationContext(), new SDKInitStatusListener(){

                public void onInitSuccess() {
                    if (callback != null) {
                        callback.onInterstitialAdInitSuccess();
                    }
                    MintegralAdapter.this.setCustomParam((Context)activity);
                }

                public void onInitFail() {
                    if (callback != null) {
                        callback.onInterstitialAdInitFailed(AdapterErrorBuilder.buildInitError((String)"Interstitial", (String)MintegralAdapter.this.mAdapterName, (String)"Mintegral Init Failed"));
                    }
                }
            });
        } else if (callback != null) {
            callback.onInterstitialAdInitFailed(AdapterErrorBuilder.buildInitError((String)"Interstitial", (String)this.mAdapterName, (String)error));
        }
    }

    public void loadInterstitialAd(Activity activity, String adUnitId, Map<String, Object> extras, InterstitialAdCallback callback) {
        super.loadInterstitialAd(activity, adUnitId, extras, callback);
        this.realLoadIsAd(activity, adUnitId, extras, callback);
    }

    private void realLoadIsAd(final Activity activity, final String adUnitId, final Map<String, Object> extras, final InterstitialAdCallback callback) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        String error = MintegralAdapter.this.check(activity, adUnitId);
                        if (TextUtils.isEmpty((CharSequence)error)) {
                            String payload = "";
                            if (extras != null && extras.containsKey(MintegralAdapter.PAY_LOAD)) {
                                payload = String.valueOf(extras.get(MintegralAdapter.PAY_LOAD));
                            }
                            if (TextUtils.isEmpty((CharSequence)payload)) {
                                MintegralAdapter.this.mBidAdUnits.remove(adUnitId);
                                MintegralAdapter.this.loadIsAd(activity, adUnitId, callback);
                            } else {
                                MintegralAdapter.this.mBidAdUnits.put(adUnitId, true);
                                MintegralAdapter.this.loadIsAdWithBid(activity, adUnitId, payload, callback);
                            }
                        } else if (callback != null) {
                            callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Interstitial", (String)MintegralAdapter.this.mAdapterName, (String)error));
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block8;
                        callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Interstitial", (String)MintegralAdapter.this.mAdapterName, (String)e.getMessage()));
                    }
                }
            }
        });
    }

    private void loadIsAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        MTGInterstitialVideoHandler mtgInterstitialVideoHandler = this.mInterstitialAds.get(adUnitId);
        if (mtgInterstitialVideoHandler == null) {
            mtgInterstitialVideoHandler = new MTGInterstitialVideoHandler((Context)activity, "", adUnitId);
            this.mInterstitialAds.put(adUnitId, mtgInterstitialVideoHandler);
            mtgInterstitialVideoHandler.setInterstitialVideoListener((InterstitialVideoListener)new MtgInterstitialAdListener(callback));
        }
        if (mtgInterstitialVideoHandler.isReady()) {
            if (callback != null) {
                callback.onInterstitialAdLoadSuccess();
            }
        } else {
            mtgInterstitialVideoHandler.load();
        }
    }

    private void loadIsAdWithBid(Activity activity, String adUnitId, String payload, InterstitialAdCallback callback) {
        MTGBidInterstitialVideoHandler mtgInterstitialVideoHandler = this.mInterstitialBidAds.get(adUnitId);
        if (mtgInterstitialVideoHandler == null) {
            mtgInterstitialVideoHandler = new MTGBidInterstitialVideoHandler((Context)activity, "", adUnitId);
            this.mInterstitialBidAds.put(adUnitId, mtgInterstitialVideoHandler);
            mtgInterstitialVideoHandler.setInterstitialVideoListener((InterstitialVideoListener)new MtgInterstitialAdListener(callback));
        }
        if (mtgInterstitialVideoHandler.isBidReady()) {
            if (callback != null) {
                callback.onInterstitialAdLoadSuccess();
            }
        } else {
            mtgInterstitialVideoHandler.loadFromBid(payload);
        }
    }

    public boolean isInterstitialAdAvailable(String adUnitId) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            return false;
        }
        if (this.mBidAdUnits.containsKey(adUnitId)) {
            MTGBidInterstitialVideoHandler bidInterstitialVideoHandler = this.mInterstitialBidAds.get(adUnitId);
            return bidInterstitialVideoHandler != null && bidInterstitialVideoHandler.isBidReady();
        }
        MTGInterstitialVideoHandler mtgInterstitialVideoHandler = this.mInterstitialAds.get(adUnitId);
        return mtgInterstitialVideoHandler != null && mtgInterstitialVideoHandler.isReady();
    }

    public void showInterstitialAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        super.showInterstitialAd(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            if (callback != null) {
                callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (String)error));
            }
            return;
        }
        this.showIsAd(adUnitId, callback);
    }

    private void showIsAd(String adUnitId, InterstitialAdCallback callback) {
        if (this.mBidAdUnits.containsKey(adUnitId)) {
            MTGBidInterstitialVideoHandler mtgInterstitialVideoHandler = this.mInterstitialBidAds.get(adUnitId);
            if (mtgInterstitialVideoHandler == null || !mtgInterstitialVideoHandler.isBidReady()) {
                if (callback != null) {
                    callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (String)"Mintegral Interstitial Ad Not Ready"));
                }
                return;
            }
            mtgInterstitialVideoHandler.showFromBid();
        } else {
            MTGInterstitialVideoHandler mtgInterstitialVideoHandler = this.mInterstitialAds.get(adUnitId);
            if (mtgInterstitialVideoHandler == null || !mtgInterstitialVideoHandler.isReady()) {
                if (callback != null) {
                    callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (String)"Mintegral Interstitial Ad Not Ready"));
                }
                return;
            }
            mtgInterstitialVideoHandler.show();
        }
    }

    private void initSDK(Context context, SDKInitStatusListener listener) {
        MintegralSingleTon.getInstance().initSDK(context, this.mAppKey, listener);
    }

    private void setCustomParam(Context context) {
        if (this.mUserAge != null) {
            this.setUserAge(context, this.mUserAge);
        }
        if (this.mUserGender != null) {
            this.setUserGender(context, this.mUserGender);
        }
    }

    private static class MtgRvAdListener
    implements RewardVideoListener {
        private RewardedVideoCallback mRvCallback;

        MtgRvAdListener(RewardedVideoCallback callback) {
            this.mRvCallback = callback;
        }

        public void onVideoLoadSuccess(String placementId, String unitId) {
            if (this.mRvCallback != null) {
                this.mRvCallback.onRewardedVideoLoadSuccess();
            }
        }

        public void onLoadSuccess(String placementId, String unitId) {
        }

        public void onVideoLoadFail(String errorMsg) {
            if (this.mRvCallback != null) {
                this.mRvCallback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Rewarded Video", (String)"MintegralAdapter", (String)errorMsg));
            }
        }

        public void onAdShow() {
            if (this.mRvCallback != null) {
                this.mRvCallback.onRewardedVideoAdShowSuccess();
                this.mRvCallback.onRewardedVideoAdStarted();
            }
        }

        public void onAdClose(boolean isCompleteView, String rewardName, float rewardAmount) {
            if (this.mRvCallback != null) {
                this.mRvCallback.onRewardedVideoAdClosed();
            }
        }

        public void onShowFail(String errorMsg) {
            if (this.mRvCallback != null) {
                this.mRvCallback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)"MintegralAdapter", (String)errorMsg));
            }
        }

        public void onVideoAdClicked(String placementId, String unitId) {
            if (this.mRvCallback != null) {
                this.mRvCallback.onRewardedVideoAdClicked();
            }
        }

        public void onVideoComplete(String placementId, String unitId) {
            if (this.mRvCallback != null) {
                this.mRvCallback.onRewardedVideoAdEnded();
                this.mRvCallback.onRewardedVideoAdRewarded();
            }
        }

        public void onEndcardShow(String placementId, String unitId) {
        }
    }

    private static class MtgInterstitialAdListener
    implements InterstitialVideoListener {
        private InterstitialAdCallback mCallback;

        MtgInterstitialAdListener(InterstitialAdCallback callback) {
            this.mCallback = callback;
        }

        public void onLoadSuccess(String placementId, String unitId) {
        }

        public void onVideoLoadSuccess(String placementId, String unitId) {
            if (this.mCallback != null) {
                this.mCallback.onInterstitialAdLoadSuccess();
            }
        }

        public void onVideoLoadFail(String errorMsg) {
            if (this.mCallback != null) {
                this.mCallback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Interstitial", (String)"MintegralAdapter", (String)errorMsg));
            }
        }

        public void onAdShow() {
            if (this.mCallback != null) {
                this.mCallback.onInterstitialAdShowSuccess();
            }
        }

        public void onAdClose(boolean b) {
            if (this.mCallback != null) {
                this.mCallback.onInterstitialAdClosed();
            }
        }

        public void onShowFail(String s) {
            if (this.mCallback != null) {
                this.mCallback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)"MintegralAdapter", (String)s));
            }
        }

        public void onVideoAdClicked(String placementId, String unitId) {
            if (this.mCallback != null) {
                this.mCallback.onInterstitialAdClick();
            }
        }

        public void onVideoComplete(String placementId, String unitId) {
        }

        public void onAdCloseWithIVReward(boolean isComplete, int rewardAlertStatus) {
        }

        public void onEndcardShow(String placementId, String unitId) {
        }
    }
}

