/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyInterstitialListener;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyRewardedVideoListener;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;
import com.openmediation.sdk.mobileads.IronSourceAdapter;
import com.openmediation.sdk.mobileads.IronSourceSetting;
import com.openmediation.sdk.utils.AdLog;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

class IronSourceManager
implements ISDemandOnlyRewardedVideoListener,
ISDemandOnlyInterstitialListener,
RewardedVideoListener,
InterstitialListener {
    private static final String MEDIATION_NAME = "AdTiming";
    private static final IronSourceManager instance = new IronSourceManager();
    private ConcurrentHashMap<String, WeakReference<IronSourceAdapter>> availableInstances = new ConcurrentHashMap();
    private ConcurrentHashMap<String, IronSourceAdapter.INSTANCE_STATE> availableStates = new ConcurrentHashMap();
    private String mLastMediationIsInsId;
    private String mLastMediationVideoInsId;
    private WeakReference<IronSourceAdapter> mLastIsAdapter;
    private WeakReference<IronSourceAdapter> mLastVideoAdapter;

    static IronSourceManager getInstance() {
        return instance;
    }

    private IronSourceManager() {
        IronSource.setISDemandOnlyRewardedVideoListener((ISDemandOnlyRewardedVideoListener)this);
        IronSource.setISDemandOnlyInterstitialListener((ISDemandOnlyInterstitialListener)this);
        IronSource.setRewardedVideoListener((RewardedVideoListener)this);
        IronSource.setInterstitialListener((InterstitialListener)this);
    }

    void initIronSourceSDK(Activity activity, String appKey, List<IronSource.AD_UNIT> adUnits) {
        IronSource.setMediationType((String)"AdTiming2.1.0");
        if (adUnits.size() > 0) {
            if (IronSourceSetting.isMediationMode()) {
                IronSource.init((Activity)activity, (String)appKey, (IronSource.AD_UNIT[])adUnits.toArray(new IronSource.AD_UNIT[adUnits.size()]));
            } else {
                IronSource.initISDemandOnly((Context)activity.getApplicationContext(), (String)appKey, (IronSource.AD_UNIT[])adUnits.toArray(new IronSource.AD_UNIT[adUnits.size()]));
            }
        }
    }

    void loadInterstitial(Activity activity, String instanceId, WeakReference<IronSourceAdapter> weakAdapter) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || weakAdapter == null) {
            this.log("loadInterstitial- instanceId / weakAdapter is null");
            return;
        }
        IronSourceAdapter ironSourceAdapter = (IronSourceAdapter)((Object)weakAdapter.get());
        if (ironSourceAdapter == null) {
            this.log("loadInterstitial - ironSourceAdapter is null");
            return;
        }
        if (IronSourceSetting.isMediationMode()) {
            this.mLastMediationIsInsId = instanceId;
            this.mLastIsAdapter = weakAdapter;
            IronSource.loadInterstitial();
            return;
        }
        if (this.canLoadInstance(instanceId)) {
            this.changeInstanceState(instanceId, IronSourceAdapter.INSTANCE_STATE.LOCKED);
            this.registerAdapter(instanceId, weakAdapter);
            IronSource.loadISDemandOnlyInterstitial((Activity)activity, (String)instanceId);
        } else {
            ironSourceAdapter.onInterstitialAdLoadFailed(instanceId, new IronSourceError(510, "interstitial instance already exists, couldn't load another one at the same time!"));
        }
    }

    void loadRewardedVideo(Activity activity, String instanceId, WeakReference<IronSourceAdapter> weakAdapter) {
        if (instanceId == null || weakAdapter == null) {
            this.log("loadRewardedVideo - instanceId / weakAdapter is null");
            return;
        }
        IronSourceAdapter ironSourceMediationAdapter = (IronSourceAdapter)((Object)weakAdapter.get());
        if (ironSourceMediationAdapter == null) {
            this.log("loadRewardedVideo - ironSourceMediationAdapter is null");
            return;
        }
        if (IronSourceSetting.isMediationMode()) {
            this.mLastMediationVideoInsId = instanceId;
            this.mLastVideoAdapter = weakAdapter;
            return;
        }
        if (this.canLoadInstance(instanceId)) {
            this.changeInstanceState(instanceId, IronSourceAdapter.INSTANCE_STATE.LOCKED);
            this.registerAdapter(instanceId, weakAdapter);
            IronSource.loadISDemandOnlyRewardedVideo((Activity)activity, (String)instanceId);
        } else {
            ironSourceMediationAdapter.onRewardedVideoAdLoadFailed(instanceId, new IronSourceError(510, "instance already exists, couldn't load another one in the same time!"));
        }
    }

    private boolean canLoadInstance(String instanceId) {
        if (!this.isAdapterRegistered(instanceId)) {
            return true;
        }
        return this.isRegisteredAdapterCanLoad(instanceId);
    }

    private boolean isRegisteredAdapterCanLoad(String instanceId) {
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter == null) {
            return true;
        }
        IronSourceAdapter ironSourceAdapter = (IronSourceAdapter)((Object)weakAdapter.get());
        if (ironSourceAdapter == null) {
            return true;
        }
        IronSourceAdapter.INSTANCE_STATE state = this.availableStates.get(instanceId);
        return state == null || state.equals((Object)IronSourceAdapter.INSTANCE_STATE.CAN_LOAD);
    }

    void showRewardedVideo(String instanceId) {
        if (IronSourceSetting.isMediationMode()) {
            IronSource.showRewardedVideo((String)instanceId);
        } else {
            IronSource.showISDemandOnlyRewardedVideo((String)instanceId);
        }
    }

    void showInterstitial(String instanceId) {
        if (IronSourceSetting.isMediationMode()) {
            IronSource.showInterstitial((String)instanceId);
        } else {
            IronSource.showISDemandOnlyInterstitial((String)instanceId);
        }
    }

    boolean isRewardedVideoReady(String instanceId) {
        if (IronSourceSetting.isMediationMode()) {
            return IronSource.isRewardedVideoAvailable();
        }
        return IronSource.isISDemandOnlyRewardedVideoAvailable((String)instanceId);
    }

    boolean isInterstitialReady(String instanceId) {
        if (IronSourceSetting.isMediationMode()) {
            return IronSource.isInterstitialReady();
        }
        return IronSource.isISDemandOnlyInterstitialReady((String)instanceId);
    }

    private void registerAdapter(String instanceId, WeakReference<IronSourceAdapter> weakAdapter) {
        if (weakAdapter == null) {
            this.log("registerAdapter - weakAdapter is null");
            return;
        }
        IronSourceAdapter ironSourceAdapter = (IronSourceAdapter)((Object)weakAdapter.get());
        if (ironSourceAdapter == null) {
            this.log("registerAdapter - ironSourceMediationAdapter is null");
            return;
        }
        this.availableInstances.put(instanceId, weakAdapter);
    }

    private boolean isAdapterRegistered(String instanceId) {
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter != null) {
            IronSourceAdapter ironSourceAdapter = (IronSourceAdapter)((Object)weakAdapter.get());
            return ironSourceAdapter != null;
        }
        return false;
    }

    public void onRewardedVideoAdLoadSuccess(String instanceId) {
        IronSourceAdapter ironSourceMediationAdapter;
        this.log(String.format("IronSourceManager got RV Load success for instance %s", instanceId));
        this.changeInstanceState(instanceId, IronSourceAdapter.INSTANCE_STATE.CAN_LOAD);
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter != null && (ironSourceMediationAdapter = (IronSourceAdapter)((Object)weakAdapter.get())) != null) {
            ironSourceMediationAdapter.onRewardedVideoAdLoadSuccess(instanceId);
        }
    }

    public void onRewardedVideoAdLoadFailed(String instanceId, IronSourceError ironSourceError) {
        IronSourceAdapter ironSourceMediationAdapter;
        this.log(String.format("IronSourceManager got RV Load failed for instance %s", instanceId));
        this.changeInstanceState(instanceId, IronSourceAdapter.INSTANCE_STATE.CAN_LOAD);
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter != null && (ironSourceMediationAdapter = (IronSourceAdapter)((Object)weakAdapter.get())) != null) {
            ironSourceMediationAdapter.onRewardedVideoAdLoadFailed(instanceId, ironSourceError);
        }
    }

    private void changeInstanceState(String instanceId, IronSourceAdapter.INSTANCE_STATE newState) {
        this.log(String.format("IronSourceManager change state to %s : %s", new Object[]{newState, instanceId}));
        this.availableStates.put(instanceId, newState);
    }

    public void onRewardedVideoAdOpened(String instanceId) {
        IronSourceAdapter ironSourceMediationAdapter;
        this.log(String.format("IronSourceManager got RV ad opened for instance %s", instanceId));
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter != null && (ironSourceMediationAdapter = (IronSourceAdapter)((Object)weakAdapter.get())) != null) {
            ironSourceMediationAdapter.onRewardedVideoAdOpened(instanceId);
            ironSourceMediationAdapter.onRewardedVideoAdStarted(instanceId);
        }
    }

    private void log(String stringToLoad) {
        AdLog.getSingleton().LogD("OM-IronSource", stringToLoad);
    }

    public void onRewardedVideoAdClosed(String instanceId) {
        IronSourceAdapter ironSourceMediationAdapter;
        this.log(String.format("IronSourceManager got RV ad closed for instance %s", instanceId));
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter != null && (ironSourceMediationAdapter = (IronSourceAdapter)((Object)weakAdapter.get())) != null) {
            ironSourceMediationAdapter.onRewardedVideoAdEnded(instanceId);
            ironSourceMediationAdapter.onRewardedVideoAdClosed(instanceId);
        }
    }

    public void onRewardedVideoAdShowFailed(String instanceId, IronSourceError ironSourceError) {
        IronSourceAdapter ironSourceMediationAdapter;
        this.log(String.format("IronSourceManager got RV show failed for instance %s", instanceId));
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter != null && (ironSourceMediationAdapter = (IronSourceAdapter)((Object)weakAdapter.get())) != null) {
            ironSourceMediationAdapter.onRewardedVideoAdShowFailed(instanceId, ironSourceError);
        }
    }

    public void onRewardedVideoAdClicked(String instanceId) {
        IronSourceAdapter ironSourceMediationAdapter;
        this.log(String.format("IronSourceManager got RV ad clicked for instance %s", instanceId));
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter != null && (ironSourceMediationAdapter = (IronSourceAdapter)((Object)weakAdapter.get())) != null) {
            ironSourceMediationAdapter.onRewardedVideoAdClicked(instanceId);
        }
    }

    public void onRewardedVideoAdRewarded(String instanceId) {
        IronSourceAdapter ironSourceMediationAdapter;
        this.log(String.format("IronSourceManager got RV ad rewarded for instance %s", instanceId));
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter != null && (ironSourceMediationAdapter = (IronSourceAdapter)((Object)weakAdapter.get())) != null) {
            ironSourceMediationAdapter.onRewardedVideoAdRewarded(instanceId);
        }
    }

    public void onInterstitialAdReady(String instanceId) {
        IronSourceAdapter ironSourceAdapter;
        this.log(String.format("IronSourceManager got interstitial Load success for instance %s", instanceId));
        this.changeInstanceState(instanceId, IronSourceAdapter.INSTANCE_STATE.CAN_LOAD);
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter != null && (ironSourceAdapter = (IronSourceAdapter)((Object)weakAdapter.get())) != null) {
            ironSourceAdapter.onInterstitialAdReady(instanceId);
        }
    }

    public void onInterstitialAdLoadFailed(String instanceId, IronSourceError ironSourceError) {
        IronSourceAdapter ironSourceAdapter;
        this.log(String.format("IronSourceManager got interstitial Load failed for instance %s", instanceId));
        this.changeInstanceState(instanceId, IronSourceAdapter.INSTANCE_STATE.CAN_LOAD);
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter != null && (ironSourceAdapter = (IronSourceAdapter)((Object)weakAdapter.get())) != null) {
            ironSourceAdapter.onInterstitialAdLoadFailed(instanceId, ironSourceError);
        }
    }

    public void onInterstitialAdOpened(String instanceId) {
        IronSourceAdapter ironSourceAdapter;
        this.log(String.format("IronSourceManager got interstitial ad opened for instance %s", instanceId));
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter != null && (ironSourceAdapter = (IronSourceAdapter)((Object)weakAdapter.get())) != null) {
            ironSourceAdapter.onInterstitialAdOpened(instanceId);
        }
    }

    public void onInterstitialAdClosed(String instanceId) {
        IronSourceAdapter ironSourceAdapter;
        this.log(String.format("IronSourceManager got interstitial ad closed for instance %s", instanceId));
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter != null && (ironSourceAdapter = (IronSourceAdapter)((Object)weakAdapter.get())) != null) {
            ironSourceAdapter.onInterstitialAdClosed(instanceId);
        }
    }

    public void onInterstitialAdShowFailed(String instanceId, IronSourceError ironSourceError) {
        IronSourceAdapter ironSourceAdapter;
        this.log(String.format("IronSourceManager got interstitial show failed for instance %s", instanceId));
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter != null && (ironSourceAdapter = (IronSourceAdapter)((Object)weakAdapter.get())) != null) {
            ironSourceAdapter.onInterstitialAdShowFailed(instanceId, ironSourceError);
        }
    }

    public void onInterstitialAdClicked(String instanceId) {
        IronSourceAdapter ironSourceAdapter;
        this.log(String.format("IronSourceManager got interstitial ad clicked for instance %s", instanceId));
        WeakReference<IronSourceAdapter> weakAdapter = this.availableInstances.get(instanceId);
        if (weakAdapter != null && (ironSourceAdapter = (IronSourceAdapter)((Object)weakAdapter.get())) != null) {
            ironSourceAdapter.onInterstitialAdClicked(instanceId);
        }
    }

    public void onInterstitialAdReady() {
        this.log("IronSourceManager got onInterstitialAdReady ");
        if (!TextUtils.isEmpty((CharSequence)this.mLastMediationIsInsId) && this.mLastIsAdapter != null && this.mLastIsAdapter.get() != null) {
            ((IronSourceAdapter)((Object)this.mLastIsAdapter.get())).onInterstitialAdReady(this.mLastMediationIsInsId);
        }
    }

    public void onInterstitialAdLoadFailed(IronSourceError ironSourceError) {
        this.log("IronSourceManager got onInterstitialAdLoadFailed ");
        if (!TextUtils.isEmpty((CharSequence)this.mLastMediationIsInsId) && this.mLastIsAdapter != null && this.mLastIsAdapter.get() != null) {
            ((IronSourceAdapter)((Object)this.mLastIsAdapter.get())).onInterstitialAdLoadFailed(this.mLastMediationIsInsId, ironSourceError);
        }
    }

    public void onInterstitialAdOpened() {
        this.log("IronSourceManager got onInterstitialAdOpened ");
        if (!TextUtils.isEmpty((CharSequence)this.mLastMediationIsInsId) && this.mLastIsAdapter != null && this.mLastIsAdapter.get() != null) {
            ((IronSourceAdapter)((Object)this.mLastIsAdapter.get())).onInterstitialAdOpened(this.mLastMediationIsInsId);
        }
    }

    public void onInterstitialAdClosed() {
        this.log("IronSourceManager got onInterstitialAdClosed ");
        if (!TextUtils.isEmpty((CharSequence)this.mLastMediationIsInsId) && this.mLastIsAdapter != null && this.mLastIsAdapter.get() != null) {
            ((IronSourceAdapter)((Object)this.mLastIsAdapter.get())).onInterstitialAdClosed(this.mLastMediationIsInsId);
        }
    }

    public void onInterstitialAdShowSucceeded() {
        this.log("IronSourceManager got onInterstitialAdShowSucceeded ");
    }

    public void onInterstitialAdShowFailed(IronSourceError ironSourceError) {
        this.log("IronSourceManager got onInterstitialAdShowFailed ");
        if (!TextUtils.isEmpty((CharSequence)this.mLastMediationIsInsId) && this.mLastIsAdapter != null && this.mLastIsAdapter.get() != null) {
            ((IronSourceAdapter)((Object)this.mLastIsAdapter.get())).onInterstitialAdShowFailed(this.mLastMediationIsInsId, ironSourceError);
        }
    }

    public void onInterstitialAdClicked() {
        this.log("IronSourceManager got onInterstitialAdClicked ");
        if (!TextUtils.isEmpty((CharSequence)this.mLastMediationIsInsId) && this.mLastIsAdapter != null && this.mLastIsAdapter.get() != null) {
            ((IronSourceAdapter)((Object)this.mLastIsAdapter.get())).onInterstitialAdClicked(this.mLastMediationIsInsId);
        }
    }

    public void onRewardedVideoAdOpened() {
        this.log("IronSourceManager got IronSourceManager got onRewardedVideoAdOpened ");
        if (!TextUtils.isEmpty((CharSequence)this.mLastMediationVideoInsId) && this.mLastVideoAdapter != null && this.mLastVideoAdapter.get() != null) {
            ((IronSourceAdapter)((Object)this.mLastVideoAdapter.get())).onRewardedVideoAdStarted(this.mLastMediationVideoInsId);
            ((IronSourceAdapter)((Object)this.mLastVideoAdapter.get())).onRewardedVideoAdOpened(this.mLastMediationVideoInsId);
        }
    }

    public void onRewardedVideoAdClosed() {
        this.log("IronSourceManager got onRewardedVideoAdClosed ");
        if (!TextUtils.isEmpty((CharSequence)this.mLastMediationVideoInsId) && this.mLastVideoAdapter != null && this.mLastVideoAdapter.get() != null) {
            ((IronSourceAdapter)((Object)this.mLastVideoAdapter.get())).onRewardedVideoAdEnded(this.mLastMediationVideoInsId);
            ((IronSourceAdapter)((Object)this.mLastVideoAdapter.get())).onRewardedVideoAdClosed(this.mLastMediationVideoInsId);
        }
    }

    public void onRewardedVideoAvailabilityChanged(boolean b) {
        this.log("IronSourceManager got onRewardedVideoAvailabilityChanged " + b);
        if (!b) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mLastMediationVideoInsId) && this.mLastVideoAdapter != null && this.mLastVideoAdapter.get() != null) {
            ((IronSourceAdapter)((Object)this.mLastVideoAdapter.get())).onRewardedVideoAdLoadSuccess(this.mLastMediationVideoInsId);
        }
    }

    public void onRewardedVideoAdStarted() {
        this.log("IronSourceManager got onRewardedVideoAdStarted ");
    }

    public void onRewardedVideoAdEnded() {
        this.log("IronSourceManager got onRewardedVideoAdEnded ");
    }

    public void onRewardedVideoAdRewarded(Placement placement) {
        this.log("IronSourceManager got onRewardedVideoAdRewarded ");
        if (!TextUtils.isEmpty((CharSequence)this.mLastMediationVideoInsId) && this.mLastVideoAdapter != null && this.mLastVideoAdapter.get() != null) {
            ((IronSourceAdapter)((Object)this.mLastVideoAdapter.get())).onRewardedVideoAdRewarded(this.mLastMediationVideoInsId);
        }
    }

    public void onRewardedVideoAdShowFailed(IronSourceError ironSourceError) {
        this.log("IronSourceManager got onRewardedVideoAdShowFailed " + ironSourceError);
        if (!TextUtils.isEmpty((CharSequence)this.mLastMediationVideoInsId) && this.mLastVideoAdapter != null && this.mLastVideoAdapter.get() != null) {
            ((IronSourceAdapter)((Object)this.mLastVideoAdapter.get())).onRewardedVideoAdShowFailed(this.mLastMediationVideoInsId, ironSourceError);
        }
    }

    public void onRewardedVideoAdClicked(Placement placement) {
        this.log("IronSourceManager got onRewardedVideoAdClicked " + placement);
        if (!TextUtils.isEmpty((CharSequence)this.mLastMediationVideoInsId) && this.mLastVideoAdapter != null && this.mLastVideoAdapter.get() != null) {
            ((IronSourceAdapter)((Object)this.mLastVideoAdapter.get())).onRewardedVideoAdClicked(this.mLastMediationVideoInsId);
        }
    }
}

