/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.BannerListener;
import com.openmediation.sdk.mediation.AdapterErrorBuilder;
import com.openmediation.sdk.mediation.CustomBannerEvent;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class IronSourceBanner
extends CustomBannerEvent
implements BannerListener {
    private AtomicBoolean mDidBannerInited = new AtomicBoolean(false);
    private IronSourceBannerLayout mIrBannerLayout;
    private boolean isFailed;

    public int getMediation() {
        return 15;
    }

    public void setGDPRConsent(Context context, boolean consent) {
        super.setGDPRConsent(context, consent);
        IronSource.setConsent((boolean)consent);
    }

    public void setUSPrivacyLimit(Context context, boolean value) {
        super.setUSPrivacyLimit(context, value);
        String sell = value ? "true" : "false";
        IronSource.setMetaData((String)"do_not_sell", (String)sell);
    }

    public void loadAd(Activity activity, Map<String, String> config) throws Throwable {
        super.loadAd(activity, config);
        if (!this.check(activity, config)) {
            return;
        }
        if (!this.mDidBannerInited.getAndSet(true)) {
            String appKey = config.get("AppKey");
            IronSource.init((Activity)activity, (String)appKey, (IronSource.AD_UNIT[])new IronSource.AD_UNIT[]{IronSource.AD_UNIT.BANNER});
        }
        if (this.mIrBannerLayout == null || this.isFailed) {
            ISBannerSize bannerSize = this.getAdSize(config);
            this.mIrBannerLayout = IronSource.createBanner((Activity)activity, (ISBannerSize)bannerSize);
            this.mIrBannerLayout.setBannerListener((BannerListener)this);
            IronSource.loadBanner((IronSourceBannerLayout)this.mIrBannerLayout);
        } else {
            this.onInsReady(this.mIrBannerLayout);
        }
    }

    public void destroy(Activity activity) {
        if (this.mIrBannerLayout != null) {
            IronSource.destroyBanner((IronSourceBannerLayout)this.mIrBannerLayout);
        }
    }

    public void onBannerAdLoaded() {
        if (this.isDestroyed) {
            return;
        }
        this.isFailed = false;
        this.onInsReady(this.mIrBannerLayout);
    }

    public void onBannerAdLoadFailed(IronSourceError error) {
        if (this.isDestroyed) {
            return;
        }
        this.isFailed = true;
        this.onInsError(AdapterErrorBuilder.buildLoadError((String)"Banner", (String)this.mAdapterName, (int)error.getErrorCode(), (String)error.getErrorMessage()));
    }

    public void onBannerAdClicked() {
        if (this.isDestroyed) {
            return;
        }
        this.onInsClicked();
    }

    public void onBannerAdScreenPresented() {
    }

    public void onBannerAdScreenDismissed() {
    }

    public void onBannerAdLeftApplication() {
    }

    private ISBannerSize getAdSize(Map<String, String> config) {
        String bannerDesc;
        switch (bannerDesc = this.getBannerDesc(config)) {
            case "LEADERBOARD": {
                return new ISBannerSize(728, 90);
            }
            case "RECTANGLE": {
                return ISBannerSize.RECTANGLE;
            }
            case "SMART": {
                return ISBannerSize.SMART;
            }
        }
        return ISBannerSize.BANNER;
    }
}

