/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.openmediation.sdk.mediation.AdapterErrorBuilder;
import com.openmediation.sdk.mediation.CustomAdsAdapter;
import com.openmediation.sdk.mediation.InterstitialAdCallback;
import com.openmediation.sdk.mediation.RewardedVideoCallback;
import com.openmediation.sdk.mobileads.IronSourceManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class IronSourceAdapter
extends CustomAdsAdapter {
    private static AtomicBoolean mDidInitInterstitial = new AtomicBoolean(false);
    private static final List<IronSource.AD_UNIT> mIsAdUnitsToInit = new ArrayList<IronSource.AD_UNIT>(Collections.singletonList(IronSource.AD_UNIT.INTERSTITIAL));
    private static AtomicBoolean mDidInitRewardedVideo = new AtomicBoolean(false);
    private static final List<IronSource.AD_UNIT> mRvAdUnitsToInit = new ArrayList<IronSource.AD_UNIT>(Collections.singletonList(IronSource.AD_UNIT.REWARDED_VIDEO));
    private ConcurrentMap<String, RewardedVideoCallback> mRvCallbacks = new ConcurrentHashMap<String, RewardedVideoCallback>();
    private ConcurrentMap<String, InterstitialAdCallback> mIsCallbacks = new ConcurrentHashMap<String, InterstitialAdCallback>();

    public String getMediationVersion() {
        return IronSourceUtils.getSDKVersion();
    }

    public String getAdapterVersion() {
        return "2.0.0";
    }

    public int getAdNetworkId() {
        return 15;
    }

    public void setGDPRConsent(Context context, boolean consent) {
        super.setGDPRConsent(context, consent);
        IronSource.setConsent((boolean)consent);
    }

    public void setUSPrivacyLimit(Context context, boolean value) {
        super.setUSPrivacyLimit(context, value);
        String sell = value ? "true" : "false";
        IronSource.setMetaData((String)"do_not_sell", (String)sell);
    }

    public void onResume(Activity activity) {
        super.onResume(activity);
        IronSource.onResume((Activity)activity);
    }

    public void onPause(Activity activity) {
        IronSource.onPause((Activity)activity);
        super.onPause(activity);
    }

    public void initRewardedVideo(Activity activity, Map<String, Object> dataMap, RewardedVideoCallback callback) {
        super.initRewardedVideo(activity, dataMap, callback);
        String error = this.check(activity);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            if (callback != null) {
                callback.onRewardedVideoInitFailed(AdapterErrorBuilder.buildInitError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
            }
            return;
        }
        if (!mDidInitRewardedVideo.getAndSet(true)) {
            IronSourceManager.getInstance().initIronSourceSDK(activity, this.mAppKey, mRvAdUnitsToInit);
        }
        if (callback != null) {
            callback.onRewardedVideoInitSuccess();
        }
    }

    public void loadRewardedVideo(Activity activity, String adUnitId, Map<String, Object> extras, RewardedVideoCallback callback) {
        super.loadRewardedVideo(activity, adUnitId, extras, callback);
        String checkError = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)checkError)) {
            if (this.isRewardedVideoAvailable(adUnitId) && callback != null) {
                callback.onRewardedVideoLoadSuccess();
                return;
            }
            if (callback != null) {
                this.mRvCallbacks.put(adUnitId, callback);
            }
            IronSourceManager.getInstance().loadRewardedVideo(adUnitId, new WeakReference<IronSourceAdapter>(this));
        } else if (callback != null) {
            callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Rewarded Video", (String)this.mAdapterName, (String)checkError));
        }
    }

    public void showRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        super.showRewardedVideo(activity, adUnitId, callback);
        String checkError = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)checkError)) {
            if (callback != null) {
                this.mRvCallbacks.put(adUnitId, callback);
            }
            IronSourceManager.getInstance().showRewardedVideo(adUnitId);
        } else if (callback != null) {
            callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)checkError));
        }
    }

    public boolean isRewardedVideoAvailable(String adUnitId) {
        return IronSourceManager.getInstance().isRewardedVideoReady(adUnitId);
    }

    public void initInterstitialAd(Activity activity, Map<String, Object> dataMap, InterstitialAdCallback callback) {
        super.initInterstitialAd(activity, dataMap, callback);
        String error = this.check(activity);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            if (callback != null) {
                callback.onInterstitialAdInitFailed(AdapterErrorBuilder.buildInitError((String)"Interstitial", (String)this.mAdapterName, (String)error));
            }
            return;
        }
        if (!mDidInitInterstitial.getAndSet(true)) {
            IronSourceManager.getInstance().initIronSourceSDK(activity, this.mAppKey, mIsAdUnitsToInit);
        }
        if (callback != null) {
            callback.onInterstitialAdInitSuccess();
        }
    }

    public void loadInterstitialAd(Activity activity, String adUnitId, Map<String, Object> extras, InterstitialAdCallback callback) {
        super.loadInterstitialAd(activity, adUnitId, extras, callback);
        String checkError = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)checkError)) {
            if (this.isInterstitialAdAvailable(adUnitId) && callback != null) {
                callback.onInterstitialAdLoadSuccess();
                return;
            }
            if (callback != null) {
                this.mIsCallbacks.put(adUnitId, callback);
            }
            IronSourceManager.getInstance().loadInterstitial(adUnitId, new WeakReference<IronSourceAdapter>(this));
        } else if (callback != null) {
            callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Interstitial", (String)this.mAdapterName, (String)checkError));
        }
    }

    public void showInterstitialAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        super.showInterstitialAd(activity, adUnitId, callback);
        String checkError = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)checkError)) {
            if (callback != null) {
                this.mIsCallbacks.put(adUnitId, callback);
            }
            IronSourceManager.getInstance().showInterstitial(adUnitId);
        } else if (callback != null) {
            callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (String)checkError));
        }
    }

    public boolean isInterstitialAdAvailable(String adUnitId) {
        return IronSourceManager.getInstance().isInterstitialReady(adUnitId);
    }

    void onInterstitialAdReady(String instanceId) {
        InterstitialAdCallback callback = (InterstitialAdCallback)this.mIsCallbacks.get(instanceId);
        if (callback != null) {
            callback.onInterstitialAdLoadSuccess();
        }
    }

    void onInterstitialAdLoadFailed(String instanceId, IronSourceError error) {
        InterstitialAdCallback callback = (InterstitialAdCallback)this.mIsCallbacks.get(instanceId);
        if (callback != null) {
            callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Interstitial", (String)this.mAdapterName, (int)error.getErrorCode(), (String)error.getErrorMessage()));
        }
    }

    void onInterstitialAdOpened(String instanceId) {
        InterstitialAdCallback callback = (InterstitialAdCallback)this.mIsCallbacks.get(instanceId);
        if (callback != null) {
            callback.onInterstitialAdShowSuccess();
        }
    }

    void onInterstitialAdClosed(String instanceId) {
        InterstitialAdCallback callback = (InterstitialAdCallback)this.mIsCallbacks.get(instanceId);
        if (callback != null) {
            callback.onInterstitialAdClosed();
        }
    }

    void onInterstitialAdShowFailed(String instanceId, IronSourceError error) {
        InterstitialAdCallback callback = (InterstitialAdCallback)this.mIsCallbacks.get(instanceId);
        if (callback != null) {
            callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (int)error.getErrorCode(), (String)error.getErrorMessage()));
        }
    }

    void onInterstitialAdClicked(String instanceId) {
        InterstitialAdCallback callback = (InterstitialAdCallback)this.mIsCallbacks.get(instanceId);
        if (callback != null) {
            callback.onInterstitialAdClick();
        }
    }

    void onRewardedVideoAdLoadSuccess(String instanceId) {
        RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(instanceId);
        if (callback != null) {
            callback.onRewardedVideoLoadSuccess();
        }
    }

    void onRewardedVideoAdLoadFailed(String instanceId, IronSourceError error) {
        RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(instanceId);
        if (callback != null) {
            callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Rewarded Video", (String)this.mAdapterName, (int)error.getErrorCode(), (String)error.getErrorMessage()));
        }
    }

    void onRewardedVideoAdOpened(String instanceId) {
        RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(instanceId);
        if (callback != null) {
            callback.onRewardedVideoAdShowSuccess();
        }
    }

    void onRewardedVideoAdStarted(String instanceId) {
        RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(instanceId);
        if (callback != null) {
            callback.onRewardedVideoAdStarted();
        }
    }

    void onRewardedVideoAdEnded(String instanceId) {
        RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(instanceId);
        if (callback != null) {
            callback.onRewardedVideoAdEnded();
        }
    }

    void onRewardedVideoAdClosed(String instanceId) {
        RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(instanceId);
        if (callback != null) {
            callback.onRewardedVideoAdClosed();
        }
    }

    void onRewardedVideoAdRewarded(String instanceId) {
        RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(instanceId);
        if (callback != null) {
            callback.onRewardedVideoAdRewarded();
        }
    }

    void onRewardedVideoAdShowFailed(String instanceId, IronSourceError error) {
        RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(instanceId);
        if (callback != null) {
            callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (int)error.getErrorCode(), (String)error.getErrorMessage()));
        }
    }

    void onRewardedVideoAdClicked(String instanceId) {
        RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(instanceId);
        if (callback != null) {
            callback.onRewardedVideoAdClicked();
        }
    }

    static enum INSTANCE_STATE {
        START,
        CAN_LOAD,
        LOCKED;

    }
}

