/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.content.Context;
import android.text.TextUtils;
import com.chartboost.heliumsdk.HeliumSdk;
import com.chartboost.heliumsdk.ad.HeliumAd;
import com.chartboost.heliumsdk.ad.HeliumAdError;
import com.chartboost.heliumsdk.ad.HeliumInterstitialAd;
import com.chartboost.heliumsdk.ad.HeliumInterstitialAdListener;
import com.chartboost.heliumsdk.ad.HeliumRewardedAd;
import com.chartboost.heliumsdk.ad.HeliumRewardedAdListener;
import com.openmediation.sdk.mobileads.HeliumBidCallback;
import com.openmediation.sdk.mobileads.HeliumInitCallback;
import com.openmediation.sdk.mobileads.HeliumInterstitialCallback;
import com.openmediation.sdk.mobileads.HeliumVideoCallback;
import com.openmediation.sdk.utils.AdLog;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class HeliumSingleTon {
    private final ConcurrentMap<String, HeliumRewardedAd> mRvAds;
    private final ConcurrentMap<String, HeliumInterstitialAd> mIsAds;
    private final ConcurrentMap<String, HeliumBidCallback> mBidCallbacks;
    private final ConcurrentMap<String, HeliumAdError> mBidError;
    private HeliumInterstitialCallback mInterstitialAdCallback;
    private HeliumVideoCallback mVideoAdCallback;
    private volatile InitState mInitState = InitState.NOT_INIT;
    private final List<HeliumInitCallback> mCallbacks = new CopyOnWriteArrayList<HeliumInitCallback>();

    private HeliumSingleTon() {
        this.mRvAds = new ConcurrentHashMap<String, HeliumRewardedAd>();
        this.mIsAds = new ConcurrentHashMap<String, HeliumInterstitialAd>();
        this.mBidCallbacks = new ConcurrentHashMap<String, HeliumBidCallback>();
        this.mBidError = new ConcurrentHashMap<String, HeliumAdError>();
    }

    public static HeliumSingleTon getInstance() {
        return CbtHolder.INSTANCE;
    }

    public void init(Context context, String appKey, HeliumInitCallback cbtCallback) {
        try {
            if (TextUtils.isEmpty((CharSequence)appKey)) {
                if (cbtCallback != null) {
                    cbtCallback.initFailed("app key is empty");
                }
                return;
            }
            if (InitState.INIT_SUCCESS == this.mInitState) {
                if (cbtCallback != null) {
                    cbtCallback.initSuccess();
                }
                return;
            }
            if (cbtCallback != null) {
                this.mCallbacks.add(cbtCallback);
            }
            if (InitState.INIT_PENDING == this.mInitState) {
                return;
            }
            this.mInitState = InitState.INIT_PENDING;
            String[] tmp = appKey.split("#");
            String appId = tmp[0];
            String signature = tmp[1];
            HeliumSdk.start((Context)context.getApplicationContext(), (String)appId, (String)signature, (HeliumSdk.HeliumSdkListener)new HeliumSdk.HeliumSdkListener(){

                public void didInitialize(Error error) {
                    if (error == null) {
                        HeliumSingleTon.this.mInitState = InitState.INIT_SUCCESS;
                        AdLog.getSingleton().LogD("Helium SDK initialized successfully");
                        for (HeliumInitCallback callback : HeliumSingleTon.this.mCallbacks) {
                            if (callback == null) continue;
                            callback.initSuccess();
                        }
                    } else {
                        HeliumSingleTon.this.mInitState = InitState.NOT_INIT;
                        AdLog.getSingleton().LogD("Helium SDK initialized failed");
                        for (HeliumInitCallback callback : HeliumSingleTon.this.mCallbacks) {
                            if (callback == null) continue;
                            callback.initFailed(error.getMessage());
                        }
                    }
                    HeliumSingleTon.this.mCallbacks.clear();
                }
            });
        }
        catch (Exception e) {
            this.mInitState = InitState.NOT_INIT;
            AdLog.getSingleton().LogE("OM-ChartboostBid", e.getMessage());
            for (HeliumInitCallback callback : this.mCallbacks) {
                if (callback == null) continue;
                callback.initFailed(e.getMessage());
            }
            this.mCallbacks.clear();
        }
    }

    InitState getInitState() {
        return this.mInitState;
    }

    void setInterstitialAdCallback(HeliumInterstitialCallback callback) {
        this.mInterstitialAdCallback = callback;
    }

    void setVideoAdCallback(HeliumVideoCallback callback) {
        this.mVideoAdCallback = callback;
    }

    void addBidCallback(String placementId, HeliumBidCallback callback) {
        if (!TextUtils.isEmpty((CharSequence)placementId) && callback != null) {
            this.mBidCallbacks.put(placementId, callback);
        }
    }

    void removeBidCallback(String placementId) {
        if (!TextUtils.isEmpty((CharSequence)placementId)) {
            this.mBidCallbacks.remove(placementId);
        }
    }

    void loadRewardedVideo(String adUnitId) {
        HeliumRewardedAd heliumAd = (HeliumRewardedAd)this.mRvAds.get(adUnitId);
        if (heliumAd != null) {
            HeliumSdk.clearLoaded((HeliumAd)heliumAd);
        }
        HeliumRewardedAd rewardedAd = new HeliumRewardedAd(adUnitId, (HeliumRewardedAdListener)new InnerRvListener());
        this.mRvAds.put(adUnitId, rewardedAd);
        rewardedAd.load();
    }

    HeliumAdError getError(String adUnitId) {
        if (!TextUtils.isEmpty((CharSequence)adUnitId)) {
            return (HeliumAdError)this.mBidError.get(adUnitId);
        }
        return null;
    }

    boolean isRewardedVideoReady(String adUnitId) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            return false;
        }
        return this.mRvAds.containsKey(adUnitId) && ((HeliumRewardedAd)this.mRvAds.get(adUnitId)).readyToShow() != false;
    }

    void showRewardedVideo(String adUnitId) {
        HeliumRewardedAd heliumRewardedAd = (HeliumRewardedAd)this.mRvAds.get(adUnitId);
        if (heliumRewardedAd != null) {
            heliumRewardedAd.show();
            this.mRvAds.remove(adUnitId);
        }
    }

    void loadInterstitial(String adUnitId) {
        HeliumInterstitialAd heliumAd = (HeliumInterstitialAd)this.mIsAds.get(adUnitId);
        if (heliumAd != null) {
            HeliumSdk.clearLoaded((HeliumAd)heliumAd);
        }
        HeliumInterstitialAd interstitialAd = new HeliumInterstitialAd(adUnitId, (HeliumInterstitialAdListener)new InnerIsListener());
        this.mIsAds.put(adUnitId, interstitialAd);
        interstitialAd.load();
    }

    boolean isInterstitialReady(String adUnitId) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            return false;
        }
        return this.mIsAds.containsKey(adUnitId) && ((HeliumInterstitialAd)this.mIsAds.get(adUnitId)).readyToShow() != false;
    }

    void showInterstitial(String adUnitId) {
        HeliumInterstitialAd heliumInterstitialAd = (HeliumInterstitialAd)this.mIsAds.get(adUnitId);
        if (heliumInterstitialAd != null) {
            heliumInterstitialAd.show();
            this.mIsAds.remove(adUnitId);
        }
    }

    private static class InnerIsListener
    implements HeliumInterstitialAdListener {
        private InnerIsListener() {
        }

        public void didReceiveWinningBid(String placementId, HashMap<String, String> hashMap) {
            AdLog.getSingleton().LogD("Helium Interstitial ad didReceiveWinningBid, placementId : " + placementId + ", " + hashMap);
            if (HeliumSingleTon.getInstance().mBidCallbacks.containsKey(placementId)) {
                ((HeliumBidCallback)HeliumSingleTon.getInstance().mBidCallbacks.get(placementId)).onBidSuccess(placementId, hashMap);
            }
        }

        public void didCache(String placementId, HeliumAdError error) {
            if (error != null) {
                AdLog.getSingleton().LogE("Helium Interstitial ad load failed : " + error.toString());
                if (HeliumSingleTon.getInstance().mBidCallbacks.containsKey(placementId)) {
                    ((HeliumBidCallback)HeliumSingleTon.getInstance().mBidCallbacks.get(placementId)).onBidFailed(placementId, error.message);
                }
                if (!TextUtils.isEmpty((CharSequence)placementId)) {
                    HeliumSingleTon.getInstance().mBidError.put(placementId, error);
                }
                return;
            }
            AdLog.getSingleton().LogD("Helium Interstitial ad complete");
        }

        public void didShow(String placementId, HeliumAdError error) {
            if (error != null) {
                AdLog.getSingleton().LogD("Helium Helium Interstitial ad show failed: " + error.toString());
                if (HeliumSingleTon.getInstance().mInterstitialAdCallback != null) {
                    HeliumSingleTon.getInstance().mInterstitialAdCallback.didInterstitialShowFailed(placementId, error);
                }
                return;
            }
            AdLog.getSingleton().LogD("Helium Helium Interstitial ad didShow");
            if (HeliumSingleTon.getInstance().mInterstitialAdCallback != null) {
                HeliumSingleTon.getInstance().mInterstitialAdCallback.didInterstitialShowed(placementId);
            }
        }

        public void didClose(String placementId, HeliumAdError error) {
            AdLog.getSingleton().LogD("Helium Helium Interstitial ad close");
            if (HeliumSingleTon.getInstance().mInterstitialAdCallback != null) {
                HeliumSingleTon.getInstance().mInterstitialAdCallback.didInterstitialClosed(placementId);
            }
        }
    }

    private static class InnerRvListener
    implements HeliumRewardedAdListener {
        private InnerRvListener() {
        }

        public void didReceiveWinningBid(String placementId, HashMap<String, String> hashMap) {
            AdLog.getSingleton().LogD("Helium RewardVideo ad didReceiveWinningBid, placementId : " + placementId + ", " + hashMap);
            if (HeliumSingleTon.getInstance().mBidCallbacks.containsKey(placementId)) {
                ((HeliumBidCallback)HeliumSingleTon.getInstance().mBidCallbacks.get(placementId)).onBidSuccess(placementId, hashMap);
            }
        }

        public void didCache(String placementId, HeliumAdError error) {
            if (error != null) {
                AdLog.getSingleton().LogE("Helium RewardedAd didCache ad error : " + placementId + " " + error.toString());
                if (HeliumSingleTon.getInstance().mBidCallbacks.containsKey(placementId)) {
                    ((HeliumBidCallback)HeliumSingleTon.getInstance().mBidCallbacks.get(placementId)).onBidFailed(placementId, error.message);
                }
                if (!TextUtils.isEmpty((CharSequence)placementId)) {
                    HeliumSingleTon.getInstance().mBidError.put(placementId, error);
                }
                return;
            }
            AdLog.getSingleton().LogD("Helium HeliumRewardedAd didCache ad load success " + placementId);
        }

        public void didShow(String placementId, HeliumAdError error) {
            if (HeliumSingleTon.getInstance().mVideoAdCallback == null) {
                return;
            }
            if (error != null) {
                AdLog.getSingleton().LogE("Helium RewardedAd didCache ad error : " + placementId + " " + error.toString());
                HeliumSingleTon.getInstance().mVideoAdCallback.didRewardedShowFailed(placementId, error);
                return;
            }
            AdLog.getSingleton().LogD("Helium RewardVideo ad display");
            HeliumSingleTon.getInstance().mVideoAdCallback.didRewardedShowed(placementId);
        }

        public void didClose(String placementId, HeliumAdError error) {
            AdLog.getSingleton().LogD("Helium RewardVideo ad close");
            if (HeliumSingleTon.getInstance().mVideoAdCallback != null) {
                HeliumSingleTon.getInstance().mVideoAdCallback.didRewardedClosed(placementId);
            }
        }

        public void didReceiveReward(String placementId, String s1) {
            AdLog.getSingleton().LogD("Helium RewardVideo ad didReceiveReward");
            if (HeliumSingleTon.getInstance().mVideoAdCallback != null) {
                HeliumSingleTon.getInstance().mVideoAdCallback.didRewardedRewarded(placementId);
            }
        }
    }

    private static class CbtHolder {
        private static final HeliumSingleTon INSTANCE = new HeliumSingleTon();

        private CbtHolder() {
        }
    }

    static enum InitState {
        NOT_INIT,
        INIT_PENDING,
        INIT_SUCCESS;

    }
}

