/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.content.Context;
import com.openmediation.sdk.bid.AdTimingBidResponse;
import com.openmediation.sdk.bid.BidAdapter;
import com.openmediation.sdk.bid.BidCallback;
import com.openmediation.sdk.mobileads.HeliumBidCallback;
import com.openmediation.sdk.mobileads.HeliumSingleTon;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class HeliumBidAdapter
extends BidAdapter
implements HeliumBidCallback {
    private final ConcurrentMap<String, BidCallback> mBidCallbacks = new ConcurrentHashMap<String, BidCallback>();

    public void initBid(Context context, Map<String, Object> dataMap, BidCallback callback) {
        super.initBid(context, dataMap, callback);
        if (context == null) {
            if (callback != null) {
                callback.bidFailed("Init Context is null");
            }
            return;
        }
        HeliumSingleTon.InitState initState = HeliumSingleTon.getInstance().getInitState();
        if (initState == HeliumSingleTon.InitState.NOT_INIT) {
            HeliumSingleTon.getInstance().init(context, String.valueOf(dataMap.get("app_key")), null);
        }
    }

    public void executeBid(Context context, Map<String, Object> dataMap, BidCallback callback) {
        super.executeBid(context, dataMap, callback);
        HeliumSingleTon.InitState initState = HeliumSingleTon.getInstance().getInitState();
        if (initState == HeliumSingleTon.InitState.NOT_INIT || initState == HeliumSingleTon.InitState.INIT_PENDING) {
            if (callback != null) {
                callback.bidFailed("Helium SDK not initialized");
            }
            return;
        }
        int adType = (Integer)dataMap.get("ad_type");
        String adUnitId = (String)dataMap.get("placement_id");
        HeliumSingleTon.getInstance().addBidCallback(adUnitId, this);
        this.mBidCallbacks.put(adUnitId, callback);
        if (adType == 3) {
            HeliumSingleTon.getInstance().loadInterstitial(adUnitId);
        } else if (adType == 2) {
            HeliumSingleTon.getInstance().loadRewardedVideo(adUnitId);
        } else {
            this.mBidCallbacks.remove(adUnitId);
            if (callback != null) {
                callback.bidFailed("unSupport bid type");
            }
        }
    }

    public void notifyWin(String placementId, Map<String, Object> dataMap) {
        super.notifyWin(placementId, dataMap);
    }

    public void notifyLose(String placementId, Map<String, Object> dataMap) {
        super.notifyLose(placementId, dataMap);
    }

    @Override
    public void onBidSuccess(String placementId, Map<String, String> map) {
        HeliumSingleTon.getInstance().removeBidCallback(placementId);
        BidCallback callback = (BidCallback)this.mBidCallbacks.get(placementId);
        if (callback == null) {
            return;
        }
        if (map == null || map.isEmpty() || !map.containsKey("price")) {
            callback.bidFailed("Helium bid failed cause no bid response");
            return;
        }
        String price = map.get("price");
        AdTimingBidResponse bidResponse = new AdTimingBidResponse();
        bidResponse.setOriginal(map.toString());
        bidResponse.setPrice(Double.parseDouble(price));
        callback.bidSuccess(bidResponse);
    }

    @Override
    public void onBidFailed(String placementId, String error) {
        HeliumSingleTon.getInstance().removeBidCallback(placementId);
        BidCallback callback = (BidCallback)this.mBidCallbacks.get(placementId);
        if (callback == null) {
            return;
        }
        callback.bidFailed(error);
    }
}

