/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.chartboost.heliumsdk.HeliumSdk;
import com.chartboost.heliumsdk.ad.HeliumAdError;
import com.openmediation.sdk.mediation.AdapterErrorBuilder;
import com.openmediation.sdk.mediation.CustomAdsAdapter;
import com.openmediation.sdk.mediation.InterstitialAdCallback;
import com.openmediation.sdk.mediation.RewardedVideoCallback;
import com.openmediation.sdk.mobileads.HeliumInitCallback;
import com.openmediation.sdk.mobileads.HeliumInterstitialCallback;
import com.openmediation.sdk.mobileads.HeliumSingleTon;
import com.openmediation.sdk.mobileads.HeliumVideoCallback;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class HeliumAdapter
extends CustomAdsAdapter
implements HeliumInterstitialCallback,
HeliumVideoCallback {
    private static final String APP_KEY = "AppKey";
    private final ConcurrentMap<String, RewardedVideoCallback> mRvCallbacks = new ConcurrentHashMap<String, RewardedVideoCallback>();
    private final ConcurrentMap<String, InterstitialAdCallback> mIsCallbacks = new ConcurrentHashMap<String, InterstitialAdCallback>();

    public String getMediationVersion() {
        return HeliumSdk.getVersion();
    }

    public String getAdapterVersion() {
        return "2.0.0";
    }

    public int getAdNetworkId() {
        return 17;
    }

    public void setGDPRConsent(Context context, boolean consent) {
        super.setGDPRConsent(context, consent);
        if (HeliumSingleTon.InitState.INIT_SUCCESS == HeliumSingleTon.getInstance().getInitState()) {
            HeliumSdk.setSubjectToGDPR((Boolean)true);
            HeliumSdk.setUserHasGivenConsent((Boolean)consent);
        }
    }

    public void setAgeRestricted(Context context, boolean restricted) {
        super.setAgeRestricted(context, restricted);
        if (HeliumSingleTon.InitState.INIT_SUCCESS == HeliumSingleTon.getInstance().getInitState()) {
            HeliumSdk.setSubjectToCoppa((Boolean)restricted);
        }
    }

    public void setUSPrivacyLimit(Context context, boolean value) {
        super.setUSPrivacyLimit(context, value);
        if (HeliumSingleTon.InitState.INIT_SUCCESS == HeliumSingleTon.getInstance().getInitState()) {
            HeliumSdk.setCCPAConsent((Boolean)(!value ? 1 : 0));
        }
    }

    public void initRewardedVideo(Activity activity, Map<String, Object> dataMap, final RewardedVideoCallback callback) {
        super.initRewardedVideo(activity, dataMap, callback);
        String checkError = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)checkError)) {
            if (dataMap.get("pid") != null && callback != null) {
                this.mRvCallbacks.put((String)dataMap.get("pid"), callback);
            }
            HeliumSingleTon.getInstance().init((Context)activity, String.valueOf(dataMap.get(APP_KEY)), new HeliumInitCallback(){

                @Override
                public void initSuccess() {
                    if (callback != null) {
                        callback.onRewardedVideoInitSuccess();
                    }
                    HeliumAdapter.this.setCustomParam();
                }

                @Override
                public void initFailed(String error) {
                    if (callback != null) {
                        callback.onRewardedVideoInitFailed(AdapterErrorBuilder.buildInitError((String)"Rewarded Video", (String)HeliumAdapter.this.mAdapterName, (String)error));
                    }
                }
            });
        } else if (callback != null) {
            callback.onRewardedVideoInitFailed(AdapterErrorBuilder.buildInitError((String)"Rewarded Video", (String)this.mAdapterName, (String)checkError));
        }
    }

    public void loadRewardedVideo(Activity activity, String adUnitId, Map<String, Object> extras, RewardedVideoCallback callback) {
        super.loadRewardedVideo(activity, adUnitId, extras, callback);
        this.realLoadRvAd(activity, adUnitId, callback);
    }

    private void realLoadRvAd(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        String checkError = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)checkError)) {
            if (this.isRewardedVideoAvailable(adUnitId)) {
                if (callback != null) {
                    callback.onRewardedVideoLoadSuccess();
                }
            } else if (callback != null) {
                HeliumAdError error = HeliumSingleTon.getInstance().getError(adUnitId);
                if (error != null) {
                    callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Rewarded Video", (String)this.mAdapterName, (int)error.code, (String)error.message));
                } else {
                    callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Rewarded Video", (String)this.mAdapterName, (String)"No Fill"));
                }
            }
        } else if (callback != null) {
            callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Rewarded Video", (String)this.mAdapterName, (String)checkError));
        }
    }

    public void showRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        String checkError = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)checkError)) {
            if (this.isRewardedVideoAvailable(adUnitId)) {
                if (callback != null) {
                    this.mRvCallbacks.put(adUnitId, callback);
                }
                HeliumSingleTon.getInstance().setVideoAdCallback(this);
                HeliumSingleTon.getInstance().showRewardedVideo(adUnitId);
            } else {
                callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)"ad not ready"));
            }
        } else if (callback != null) {
            callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)checkError));
        }
    }

    public boolean isRewardedVideoAvailable(String adUnitId) {
        return HeliumSingleTon.getInstance().isRewardedVideoReady(adUnitId);
    }

    public void initInterstitialAd(Activity activity, Map<String, Object> dataMap, final InterstitialAdCallback callback) {
        super.initInterstitialAd(activity, dataMap, callback);
        String checkError = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)checkError)) {
            if (dataMap.get("pid") != null && callback != null) {
                this.mIsCallbacks.put((String)dataMap.get("pid"), callback);
            }
            HeliumSingleTon.getInstance().init((Context)activity, String.valueOf(dataMap.get(APP_KEY)), new HeliumInitCallback(){

                @Override
                public void initSuccess() {
                    if (callback != null) {
                        callback.onInterstitialAdInitSuccess();
                    }
                    HeliumAdapter.this.setCustomParam();
                }

                @Override
                public void initFailed(String error) {
                    if (callback != null) {
                        callback.onInterstitialAdInitFailed(AdapterErrorBuilder.buildInitError((String)"Interstitial", (String)HeliumAdapter.this.mAdapterName, (String)error));
                    }
                }
            });
        } else if (callback != null) {
            callback.onInterstitialAdInitFailed(AdapterErrorBuilder.buildInitError((String)"Interstitial", (String)this.mAdapterName, (String)checkError));
        }
    }

    public void loadInterstitialAd(Activity activity, String adUnitId, Map<String, Object> extras, InterstitialAdCallback callback) {
        super.loadInterstitialAd(activity, adUnitId, extras, callback);
        this.realLoadIsAd(activity, adUnitId, callback);
    }

    private void realLoadIsAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        String checkError = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)checkError)) {
            if (this.isInterstitialAdAvailable(adUnitId)) {
                if (callback != null) {
                    callback.onInterstitialAdLoadSuccess();
                }
            } else if (callback != null) {
                HeliumAdError error = HeliumSingleTon.getInstance().getError(adUnitId);
                if (error != null) {
                    callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Interstitial", (String)this.mAdapterName, (int)error.code, (String)error.message));
                } else {
                    callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Interstitial", (String)this.mAdapterName, (String)"No Fill"));
                }
            }
        } else if (callback != null) {
            callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Interstitial", (String)this.mAdapterName, (String)checkError));
        }
    }

    public void showInterstitialAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        super.showInterstitialAd(activity, adUnitId, callback);
        String checkError = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)checkError)) {
            if (this.isInterstitialAdAvailable(adUnitId)) {
                if (callback != null) {
                    this.mIsCallbacks.put(adUnitId, callback);
                }
                HeliumSingleTon.getInstance().setInterstitialAdCallback(this);
                HeliumSingleTon.getInstance().showInterstitial(adUnitId);
            } else {
                callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (String)"ad not ready"));
            }
        } else if (callback != null) {
            callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (String)checkError));
        }
    }

    public boolean isInterstitialAdAvailable(String adUnitId) {
        return HeliumSingleTon.getInstance().isInterstitialReady(adUnitId);
    }

    @Override
    public void didRewardedShowed(String placementId) {
        RewardedVideoCallback listener = (RewardedVideoCallback)this.mRvCallbacks.get(placementId);
        if (listener == null) {
            return;
        }
        listener.onRewardedVideoAdShowSuccess();
        listener.onRewardedVideoAdStarted();
    }

    @Override
    public void didRewardedShowFailed(String placementId, HeliumAdError error) {
        RewardedVideoCallback listener = (RewardedVideoCallback)this.mRvCallbacks.get(placementId);
        if (listener == null) {
            return;
        }
        listener.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (int)error.getCode(), (String)error.getMessage()));
    }

    @Override
    public void didRewardedClosed(String placementId) {
        RewardedVideoCallback listener = (RewardedVideoCallback)this.mRvCallbacks.get(placementId);
        if (listener != null) {
            listener.onRewardedVideoAdClosed();
        }
    }

    @Override
    public void didRewardedRewarded(String placementId) {
        RewardedVideoCallback listener = (RewardedVideoCallback)this.mRvCallbacks.get(placementId);
        if (listener != null) {
            listener.onRewardedVideoAdRewarded();
            listener.onRewardedVideoAdEnded();
        }
    }

    @Override
    public void didInterstitialShowed(String placementId) {
        InterstitialAdCallback listener = (InterstitialAdCallback)this.mIsCallbacks.get(placementId);
        if (listener == null) {
            return;
        }
        listener.onInterstitialAdShowSuccess();
    }

    @Override
    public void didInterstitialShowFailed(String placementId, HeliumAdError error) {
        InterstitialAdCallback listener = (InterstitialAdCallback)this.mIsCallbacks.get(placementId);
        if (listener == null) {
            return;
        }
        listener.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (int)error.getCode(), (String)error.getMessage()));
    }

    @Override
    public void didInterstitialClosed(String placementId) {
        InterstitialAdCallback listener = (InterstitialAdCallback)this.mIsCallbacks.get(placementId);
        if (listener != null) {
            listener.onInterstitialAdClosed();
        }
    }

    private void setCustomParam() {
        if (this.mUserConsent != null) {
            this.setGDPRConsent(null, this.mUserConsent);
        }
        if (this.mAgeRestricted != null) {
            this.setAgeRestricted(null, this.mAgeRestricted);
        }
        if (this.mUSPrivacyLimit != null) {
            this.setUSPrivacyLimit(null, this.mUSPrivacyLimit);
        }
    }
}

