/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.adtbid.sdk.AdTimingAds;
import com.adtbid.sdk.interstitial.AdTimingInterstitialAd;
import com.adtbid.sdk.interstitial.InterstitialAdListener;
import com.adtbid.sdk.utils.error.AdTimingError;
import com.adtbid.sdk.video.AdTimingRewardedVideo;
import com.adtbid.sdk.video.RewardedVideoListener;
import com.openmediation.sdk.mediation.AdapterErrorBuilder;
import com.openmediation.sdk.mediation.CustomAdsAdapter;
import com.openmediation.sdk.mediation.InterstitialAdCallback;
import com.openmediation.sdk.mediation.RewardedVideoCallback;
import com.openmediation.sdk.mobileads.AdTimingSingleTon;
import com.openmediation.sdk.utils.AdLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AdTimingAdapter
extends CustomAdsAdapter
implements RewardedVideoListener,
InterstitialAdListener {
    private static final String TAG = "OM-AdTiming: ";
    private static final String PAY_LOAD = "pay_load";
    private ConcurrentMap<String, RewardedVideoCallback> mVideoListeners = new ConcurrentHashMap<String, RewardedVideoCallback>();
    private ConcurrentMap<String, InterstitialAdCallback> mInterstitialListeners = new ConcurrentHashMap<String, InterstitialAdCallback>();

    public String getMediationVersion() {
        return AdTimingAds.getSDKVersion();
    }

    public String getAdapterVersion() {
        return "2.0.0";
    }

    public int getAdNetworkId() {
        return 1;
    }

    public void setGDPRConsent(Context context, boolean consent) {
        super.setGDPRConsent(context, consent);
        AdTimingAds.setGDPRConsent((boolean)consent);
    }

    public void setUSPrivacyLimit(Context context, boolean value) {
        super.setUSPrivacyLimit(context, value);
        AdTimingAds.setAgeRestricted((boolean)value);
    }

    public void setAgeRestricted(Context context, boolean restricted) {
        super.setAgeRestricted(context, restricted);
        AdTimingAds.setAgeRestricted((boolean)restricted);
    }

    public void setUserAge(Context context, int age) {
        super.setUserAge(context, age);
        AdTimingAds.setUserAge((int)age);
    }

    public void setUserGender(Context context, String gender) {
        super.setUserGender(context, gender);
        AdTimingAds.setUserGender((String)gender);
    }

    public void onResume(Activity activity) {
        super.onResume(activity);
        AdTimingAds.onResume((Activity)activity);
    }

    public void onPause(Activity activity) {
        AdTimingAds.onPause((Activity)activity);
        super.onPause(activity);
    }

    public void initRewardedVideo(Activity activity, Map<String, Object> dataMap, RewardedVideoCallback callback) {
        super.initRewardedVideo(activity, dataMap, callback);
        String error = this.check(activity);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            callback.onRewardedVideoInitFailed(AdapterErrorBuilder.buildInitError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
            return;
        }
        String pid = (String)dataMap.get("pid");
        this.mVideoListeners.put(pid, callback);
        String appKey = (String)dataMap.get("AppKey");
        this.initSDK(activity, appKey);
    }

    public void loadRewardedVideo(Activity activity, String adUnitId, Map<String, Object> extras, RewardedVideoCallback callback) {
        super.loadRewardedVideo(activity, adUnitId, extras, callback);
        this.loadRewardedVideoAd(activity, adUnitId, extras, callback);
    }

    private void loadRewardedVideoAd(Activity activity, String adUnitId, Map<String, Object> extras, RewardedVideoCallback callback) {
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
            return;
        }
        this.mVideoListeners.put(adUnitId, callback);
        AdTimingRewardedVideo.setAdListener((String)adUnitId, (RewardedVideoListener)this);
        String payload = "";
        if (extras != null && extras.containsKey(PAY_LOAD)) {
            payload = String.valueOf(extras.get(PAY_LOAD));
        }
        AdTimingRewardedVideo.loadAdWithPayload((String)adUnitId, (String)payload);
    }

    public void showRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        super.showRewardedVideo(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
            return;
        }
        if (this.isRewardedVideoAvailable(adUnitId)) {
            AdTimingRewardedVideo.setAdListener((String)adUnitId, (RewardedVideoListener)this);
            AdTimingRewardedVideo.showAd((String)adUnitId);
        } else {
            callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)"no reward ad or not ready"));
        }
    }

    public boolean isRewardedVideoAvailable(String adUnitId) {
        return AdTimingRewardedVideo.isReady((String)adUnitId);
    }

    public void initInterstitialAd(Activity activity, Map<String, Object> dataMap, InterstitialAdCallback callback) {
        super.initInterstitialAd(activity, dataMap, callback);
        String error = this.check(activity);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            callback.onInterstitialAdInitFailed(AdapterErrorBuilder.buildInitError((String)"Interstitial", (String)this.mAdapterName, (String)error));
            return;
        }
        String pid = (String)dataMap.get("pid");
        this.mInterstitialListeners.put(pid, callback);
        String appKey = (String)dataMap.get("AppKey");
        this.initSDK(activity, appKey);
    }

    public void loadInterstitialAd(Activity activity, String adUnitId, Map<String, Object> extras, InterstitialAdCallback callback) {
        super.loadInterstitialAd(activity, adUnitId, extras, callback);
        this.loadIsAd(activity, adUnitId, extras, callback);
    }

    private void loadIsAd(Activity activity, String adUnitId, Map<String, Object> extras, InterstitialAdCallback callback) {
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Interstitial", (String)this.mAdapterName, (String)error));
            return;
        }
        String payload = "";
        if (extras != null && extras.containsKey(PAY_LOAD)) {
            payload = String.valueOf(extras.get(PAY_LOAD));
        }
        this.mInterstitialListeners.put(adUnitId, callback);
        AdTimingInterstitialAd.setAdListener((String)adUnitId, (InterstitialAdListener)this);
        AdTimingInterstitialAd.loadAdWithPayload((String)adUnitId, (String)payload);
    }

    public void showInterstitialAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        super.showInterstitialAd(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (String)error));
            return;
        }
        if (this.isInterstitialAdAvailable(adUnitId)) {
            AdTimingInterstitialAd.setAdListener((String)adUnitId, (InterstitialAdListener)this);
            AdTimingInterstitialAd.showAd((String)adUnitId);
        } else {
            callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (String)"no interstitial ad or not ready"));
        }
    }

    public boolean isInterstitialAdAvailable(String adUnitId) {
        return AdTimingInterstitialAd.isReady((String)adUnitId);
    }

    private void initSDK(Activity activity, String appKey) {
        AdTimingSingleTon.getInstance().initAdTiming((Context)activity, appKey, new AdTimingSingleTon.AdTimingInitCallback(){

            @Override
            public void onSuccess() {
                if (!AdTimingAdapter.this.mVideoListeners.isEmpty()) {
                    for (Map.Entry rewardedVideoCallbackEntry : AdTimingAdapter.this.mVideoListeners.entrySet()) {
                        if (rewardedVideoCallbackEntry == null) continue;
                        ((RewardedVideoCallback)rewardedVideoCallbackEntry.getValue()).onRewardedVideoInitSuccess();
                    }
                    AdTimingAdapter.this.mVideoListeners.clear();
                }
                if (!AdTimingAdapter.this.mInterstitialListeners.isEmpty()) {
                    for (Map.Entry interstitialAdCallbackEntry : AdTimingAdapter.this.mInterstitialListeners.entrySet()) {
                        if (interstitialAdCallbackEntry == null) continue;
                        ((InterstitialAdCallback)interstitialAdCallbackEntry.getValue()).onInterstitialAdInitSuccess();
                    }
                }
                AdTimingAdapter.this.mInterstitialListeners.clear();
            }

            @Override
            public void onError(AdTimingError adTimingError) {
                if (!AdTimingAdapter.this.mVideoListeners.isEmpty()) {
                    for (Map.Entry rewardedVideoCallbackEntry : AdTimingAdapter.this.mVideoListeners.entrySet()) {
                        if (rewardedVideoCallbackEntry == null) continue;
                        ((RewardedVideoCallback)rewardedVideoCallbackEntry.getValue()).onRewardedVideoInitFailed(AdapterErrorBuilder.buildInitError((String)"Rewarded Video", (String)AdTimingAdapter.this.mAdapterName, (int)adTimingError.getCode(), (String)adTimingError.getMessage()));
                    }
                    AdTimingAdapter.this.mVideoListeners.clear();
                }
                if (!AdTimingAdapter.this.mInterstitialListeners.isEmpty()) {
                    for (Map.Entry interstitialAdCallbackEntry : AdTimingAdapter.this.mInterstitialListeners.entrySet()) {
                        if (interstitialAdCallbackEntry == null) continue;
                        ((InterstitialAdCallback)interstitialAdCallbackEntry.getValue()).onInterstitialAdInitFailed(AdapterErrorBuilder.buildInitError((String)"Interstitial", (String)AdTimingAdapter.this.mAdapterName, (int)adTimingError.getCode(), (String)adTimingError.getMessage()));
                    }
                    AdTimingAdapter.this.mInterstitialListeners.clear();
                }
            }
        });
    }

    public void onInterstitialAdLoadSuccess(String placementId) {
        try {
            AdLog.getSingleton().LogD("OM-AdTiming: onInterstitialAdReady : " + placementId);
            InterstitialAdCallback callback = (InterstitialAdCallback)this.mInterstitialListeners.get(placementId);
            if (callback != null) {
                callback.onInterstitialAdLoadSuccess();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onInterstitialAdClosed(String placementId) {
        try {
            AdLog.getSingleton().LogD("OM-AdTiming: onInterstitialAdClose : " + placementId);
            InterstitialAdCallback callback = (InterstitialAdCallback)this.mInterstitialListeners.get(placementId);
            if (callback != null) {
                callback.onInterstitialAdClosed();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onInterstitialAdShowed(String placementId) {
        try {
            AdLog.getSingleton().LogD("OM-AdTiming: onInterstitialAdShowed : " + placementId);
            InterstitialAdCallback callback = (InterstitialAdCallback)this.mInterstitialListeners.get(placementId);
            if (callback != null) {
                callback.onInterstitialAdShowSuccess();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onInterstitialAdLoadFailed(String placementId, AdTimingError error) {
        try {
            AdLog.getSingleton().LogE("OM-AdTiming: InterstitialAd Load Failed: " + error);
            InterstitialAdCallback callback = (InterstitialAdCallback)this.mInterstitialListeners.get(placementId);
            if (callback != null) {
                callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Interstitial", (String)this.mAdapterName, (int)error.getCode(), (String)error.getMessage()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onInterstitialAdClicked(String placementId) {
        try {
            AdLog.getSingleton().LogD("OM-AdTiming: onInterstitialAdClicked : " + placementId);
            InterstitialAdCallback callback = (InterstitialAdCallback)this.mInterstitialListeners.get(placementId);
            if (callback != null) {
                callback.onInterstitialAdClick();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onInterstitialAdShowFailed(String placementId, AdTimingError error) {
        try {
            InterstitialAdCallback callback = (InterstitialAdCallback)this.mInterstitialListeners.get(placementId);
            if (callback != null) {
                callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (int)error.getCode(), (String)error.getMessage()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onRewardedVideoAdLoadSuccess(String placementId) {
        try {
            AdLog.getSingleton().LogD("OM-AdTiming: onVideoAdReady : " + placementId);
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mVideoListeners.get(placementId);
            if (callback != null) {
                callback.onRewardedVideoLoadSuccess();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onRewardedVideoAdClosed(String placementId) {
        try {
            AdLog.getSingleton().LogD("OM-AdTiming: onVideoAdClose : " + placementId);
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mVideoListeners.get(placementId);
            if (callback != null) {
                callback.onRewardedVideoAdClosed();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onRewardedVideoAdShowed(String placementId) {
        try {
            AdLog.getSingleton().LogD("OM-AdTiming: onVideoAdShowed : " + placementId);
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mVideoListeners.get(placementId);
            if (callback != null) {
                callback.onRewardedVideoAdShowSuccess();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onRewardedVideoAdRewarded(String placementId) {
        try {
            AdLog.getSingleton().LogD("OM-AdTiming: onVideoAdRewarded : " + placementId);
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mVideoListeners.get(placementId);
            if (callback != null) {
                callback.onRewardedVideoAdRewarded();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onRewardedVideoAdLoadFailed(String placementId, AdTimingError error) {
        try {
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mVideoListeners.get(placementId);
            if (callback != null) {
                callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Rewarded Video", (String)this.mAdapterName, (int)error.getCode(), (String)error.getMessage()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onRewardedVideoAdClicked(String placementId) {
        try {
            AdLog.getSingleton().LogD("OM-AdTiming: onVideoAdClicked : " + placementId);
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mVideoListeners.get(placementId);
            if (callback != null) {
                callback.onRewardedVideoAdClicked();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onRewardedVideoAdShowFailed(String placementId, AdTimingError error) {
        try {
            AdLog.getSingleton().LogE("OM-AdTiming: onVideoAdShowFailed : " + placementId + " cause :" + error);
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mVideoListeners.get(placementId);
            if (callback != null) {
                callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (int)error.getCode(), (String)error.getMessage()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onRewardedVideoAdStarted(String placementId) {
        try {
            AdLog.getSingleton().LogD("OM-AdTiming: onVideoStarted : " + placementId);
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mVideoListeners.get(placementId);
            if (callback != null) {
                callback.onRewardedVideoAdStarted();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onRewardedVideoAdEnded(String placementId) {
        try {
            AdLog.getSingleton().LogD("OM-AdTiming: onVideoEnded : " + placementId);
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mVideoListeners.get(placementId);
            if (callback != null) {
                callback.onRewardedVideoAdEnded();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

