/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.adcolony.sdk.AdColony;
import com.adcolony.sdk.AdColonyAppOptions;
import com.adcolony.sdk.AdColonyInterstitial;
import com.adcolony.sdk.AdColonyInterstitialListener;
import com.adcolony.sdk.AdColonyReward;
import com.adcolony.sdk.AdColonyRewardListener;
import com.adcolony.sdk.AdColonyZone;
import com.openmediation.sdk.mediation.AdapterErrorBuilder;
import com.openmediation.sdk.mediation.CustomAdsAdapter;
import com.openmediation.sdk.mediation.RewardedVideoCallback;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AdColonyAdapter
extends CustomAdsAdapter
implements AdColonyRewardListener {
    private boolean mDidInited = false;
    private ConcurrentMap<String, RewardedVideoCallback> mRvCallback = new ConcurrentHashMap<String, RewardedVideoCallback>();
    private ConcurrentHashMap<String, AdColonyInterstitial> mAdColonyAds = new ConcurrentHashMap();
    private AdColonyAppOptions mAdColonyOptions = new AdColonyAppOptions();

    public String getMediationVersion() {
        return AdColony.getSDKVersion();
    }

    public String getAdapterVersion() {
        return "2.0.0";
    }

    public int getAdNetworkId() {
        return 7;
    }

    public void setGDPRConsent(Context context, boolean consent) {
        super.setGDPRConsent(context, consent);
        try {
            this.mAdColonyOptions.setPrivacyConsentString("GDPR", consent ? "1" : "0");
            this.mAdColonyOptions.setPrivacyFrameworkRequired("GDPR", true);
            AdColony.setAppOptions((AdColonyAppOptions)this.mAdColonyOptions);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUSPrivacyLimit(Context context, boolean value) {
        super.setUSPrivacyLimit(context, value);
        try {
            this.mAdColonyOptions.setPrivacyConsentString("CCPA", value ? "1" : "0");
            this.mAdColonyOptions.setPrivacyFrameworkRequired("CCPA", true);
            AdColony.setAppOptions((AdColonyAppOptions)this.mAdColonyOptions);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initRewardedVideo(Activity activity, Map<String, Object> dataMap, RewardedVideoCallback callback) {
        super.initRewardedVideo(activity, dataMap, callback);
        String error = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)error)) {
            this.initAdColony(activity, dataMap);
            if (callback != null) {
                callback.onRewardedVideoInitSuccess();
            }
        } else if (callback != null) {
            callback.onRewardedVideoInitFailed(AdapterErrorBuilder.buildInitError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
        }
    }

    public void loadRewardedVideo(Activity activity, String adUnitId, Map<String, Object> extras, RewardedVideoCallback callback) {
        super.loadRewardedVideo(activity, adUnitId, extras, callback);
        String error = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)error)) {
            AdColonyInterstitial rvAd = this.mAdColonyAds.get(adUnitId);
            this.mRvCallback.put(adUnitId, callback);
            if (rvAd == null || rvAd.isExpired()) {
                AdColony.setRewardListener((AdColonyRewardListener)this);
                AdColony.requestInterstitial((String)adUnitId, (AdColonyInterstitialListener)new AdColonyAdListener());
            } else if (!rvAd.isExpired()) {
                callback.onRewardedVideoLoadSuccess();
            }
        } else {
            callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
        }
    }

    public void showRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        super.showRewardedVideo(activity, adUnitId, callback);
        if (this.isRewardedVideoAvailable(adUnitId)) {
            AdColonyInterstitial interstitial = this.mAdColonyAds.get(adUnitId);
            if (interstitial != null) {
                interstitial.show();
            } else if (callback != null) {
                callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)"AdColony ad not ready"));
            }
        } else if (callback != null) {
            callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)"AdColony ad not ready"));
        }
    }

    public boolean isRewardedVideoAvailable(String adUnitId) {
        try {
            if (TextUtils.isEmpty((CharSequence)adUnitId)) {
                return false;
            }
            AdColonyInterstitial interstitial = this.mAdColonyAds.get(adUnitId);
            return interstitial != null && !interstitial.isExpired();
        }
        catch (Exception ex) {
            return false;
        }
    }

    private synchronized void initAdColony(Activity activity, Map<String, Object> dataMap) {
        if (!this.mDidInited) {
            List idList = null;
            if (dataMap.get("zoneIds") instanceof List) {
                idList = (List)dataMap.get("zoneIds");
            }
            if (idList != null) {
                String[] zoneIds = idList.toArray(new String[idList.size()]);
                AdColony.configure((Application)activity.getApplication(), (AdColonyAppOptions)this.mAdColonyOptions, (String)this.mAppKey, (String[])zoneIds);
            } else {
                AdColony.configure((Application)activity.getApplication(), (AdColonyAppOptions)this.mAdColonyOptions, (String)this.mAppKey, (String[])new String[0]);
            }
            this.mDidInited = true;
        }
    }

    public void onReward(AdColonyReward adColonyReward) {
        RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallback.get(adColonyReward.getZoneID());
        if (adColonyReward.success() && callback != null) {
            callback.onRewardedVideoAdRewarded();
        }
    }

    private class AdColonyAdListener
    extends AdColonyInterstitialListener {
        private AdColonyAdListener() {
        }

        public void onRequestFilled(AdColonyInterstitial var1) {
            AdColonyAdapter.this.mAdColonyAds.put(var1.getZoneID(), var1);
            RewardedVideoCallback callback = (RewardedVideoCallback)AdColonyAdapter.this.mRvCallback.get(var1.getZoneID());
            if (callback != null) {
                callback.onRewardedVideoLoadSuccess();
            }
        }

        public void onRequestNotFilled(AdColonyZone zone) {
            RewardedVideoCallback callback = (RewardedVideoCallback)AdColonyAdapter.this.mRvCallback.get(zone.getZoneID());
            if (callback != null) {
                callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Rewarded Video", (String)AdColonyAdapter.this.mAdapterName, (String)"Request Not Filled"));
            }
        }

        public void onOpened(AdColonyInterstitial ad) {
            RewardedVideoCallback callback = (RewardedVideoCallback)AdColonyAdapter.this.mRvCallback.get(ad.getZoneID());
            if (callback != null) {
                callback.onRewardedVideoAdShowSuccess();
                callback.onRewardedVideoAdStarted();
            }
        }

        public void onClosed(AdColonyInterstitial ad) {
            RewardedVideoCallback callback = (RewardedVideoCallback)AdColonyAdapter.this.mRvCallback.get(ad.getZoneID());
            if (callback != null) {
                callback.onRewardedVideoAdEnded();
                callback.onRewardedVideoAdClosed();
            }
        }

        public void onExpiring(AdColonyInterstitial ad) {
            AdColony.requestInterstitial((String)ad.getZoneID(), (AdColonyInterstitialListener)this);
        }

        public void onClicked(AdColonyInterstitial ad) {
            RewardedVideoCallback callback = (RewardedVideoCallback)AdColonyAdapter.this.mRvCallback.get(ad.getZoneID());
            if (callback != null) {
                callback.onRewardedVideoAdClicked();
            }
        }
    }
}

