/*
 * Decompiled with CFR 0.152.
 */
package com.guagua.guagua.image.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import androidx.appcompat.widget.AppCompatImageView;
import com.guagua.guagua.image.R;
import java.util.Arrays;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J0\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/guagua/guagua/image/view/SquareImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "SHAPE_MODE_CIRCLE", "", "SHAPE_MODE_ROUND_RECT", "mPaint", "Landroid/graphics/Paint;", "mRadius", "", "mShape", "Landroid/graphics/drawable/shapes/Shape;", "mShapeMode", "paint", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onLayout", "changed", "", "left", "top", "right", "bottom", "imagepicker_release"})
public final class SquareImageView
extends AppCompatImageView {
    private final Paint paint;
    private final int SHAPE_MODE_ROUND_RECT = 1;
    private final int SHAPE_MODE_CIRCLE = 2;
    private int mShapeMode;
    private float mRadius;
    private Shape mShape;
    private Paint mPaint;
    private HashMap _$_findViewCache;

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            int n = this.mShapeMode;
            if (n != this.SHAPE_MODE_ROUND_RECT && n == this.SHAPE_MODE_CIRCLE) {
                int min = Math.min(this.getWidth(), this.getHeight());
                this.mRadius = (float)min / (float)2;
            }
            if (this.mShape == null) {
                float[] radius = new float[8];
                Arrays.fill(radius, this.mRadius);
                this.mShape = (Shape)new RoundRectShape(radius, null, null);
            }
            Shape shape = this.mShape;
            if (shape == null) {
                Intrinsics.throwNpe();
            }
            shape.resize((float)this.getWidth(), (float)this.getHeight());
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        int saveCount = canvas.getSaveCount();
        canvas.save();
        super.onDraw(canvas);
        int n = this.mShapeMode;
        if ((n == this.SHAPE_MODE_ROUND_RECT || n == this.SHAPE_MODE_CIRCLE) && this.mShape != null) {
            Shape shape = this.mShape;
            if (shape == null) {
                Intrinsics.throwNpe();
            }
            shape.draw(canvas, this.mPaint);
        }
        canvas.restoreToCount(saveCount);
    }

    public SquareImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.paint = new Paint(1);
        this.SHAPE_MODE_ROUND_RECT = 1;
        this.SHAPE_MODE_CIRCLE = 2;
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(2, null);
        }
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ShapedImageView);
            this.mShapeMode = a.getInt(R.styleable.ShapedImageView_shape_mode, 0);
            this.mRadius = a.getDimension(R.styleable.ShapedImageView_round_radius, 0.0f);
            a.recycle();
        }
        this.paint.setFilterBitmap(true);
        this.paint.setColor(-16777216);
        this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

