/*
 * Decompiled with CFR 0.152.
 */
package com.guagua.guagua.image.utils;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lcom/guagua/guagua/image/utils/Utils;", "", "()V", "getImageTime", "", "timestamp", "", "getScreenSize", "", "context", "Landroid/content/Context;", "getVideoDuration", "imagepicker_release"})
public final class Utils {
    public static final Utils INSTANCE;

    @NotNull
    public final int[] getScreenSize(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return new int[]{displayMetrics.widthPixels, displayMetrics.heightPixels};
    }

    @NotNull
    public final String getImageTime(long timestamp) {
        Calendar imageCalendar;
        Calendar currentCalendar;
        Calendar calendar = currentCalendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"currentCalendar");
        calendar.setTime(new Date());
        Calendar calendar2 = imageCalendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"imageCalendar");
        calendar2.setTimeInMillis(timestamp);
        if (currentCalendar.get(6) == imageCalendar.get(6) && currentCalendar.get(1) == imageCalendar.get(1)) {
            return "\u4eca\u5929";
        }
        if (currentCalendar.get(3) == imageCalendar.get(3) && currentCalendar.get(1) == imageCalendar.get(1)) {
            return "\u672c\u5468";
        }
        if (currentCalendar.get(2) == imageCalendar.get(2) && currentCalendar.get(1) == imageCalendar.get(1)) {
            return "\u672c\u6708";
        }
        Date date = new Date(timestamp);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM");
        String string2 = sdf.format(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sdf.format(date)");
        return string2;
    }

    @NotNull
    public final String getVideoDuration(long timestamp) {
        if (timestamp < (long)1000) {
            return "00:01";
        }
        Date date = new Date(timestamp);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm:ss");
        String string2 = simpleDateFormat.format(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"simpleDateFormat.format(date)");
        return string2;
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

